/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.RequestMessage$;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.util.ByteBufferOutputStream;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra!B\u0001\u0003\u0001\ta!A\u0004*fcV,7\u000f^'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tQA\\3uifT!!\u0002\u0004\u0002\u0007I\u00048M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005i1/\u001a8eKJ\fE\r\u001a:fgN\u001c\u0001!F\u0001\u0018!\tA\u0012$D\u0001\u0005\u0013\tQBA\u0001\u0006Sa\u000e\fE\r\u001a:fgND\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000fg\u0016tG-\u001a:BI\u0012\u0014Xm]:!\u0011!q\u0002A!b\u0001\n\u0003y\u0012\u0001\u0003:fG\u0016Lg/\u001a:\u0016\u0003\u0001\u0002\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003'9+G\u000f^=Sa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0001\n\u0011B]3dK&4XM\u001d\u0011\t\u0011\u001d\u0002!Q1A\u0005\u0002!\nqaY8oi\u0016tG/F\u0001*!\tq!&\u0003\u0002,\u001f\t\u0019\u0011I\\=\t\u00115\u0002!\u0011!Q\u0001\n%\n\u0001bY8oi\u0016tG\u000f\t\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\tE\u00124\u0007\u000e\t\u0003C\u0001AQ\u0001\u0006\u0018A\u0002]AQA\b\u0018A\u0002\u0001BQa\n\u0018A\u0002%BQA\u000e\u0001\u0005\u0002]\n\u0011b]3sS\u0006d\u0017N_3\u0015\u0005a\u0002\u0005CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\rq\u0017n\u001c\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0006CsR,')\u001e4gKJDQ!Q\u001bA\u0002\t\u000b\u0001B\\3uif,eN\u001e\t\u0003C\rK!\u0001\u0012\u0002\u0003\u00179+G\u000f^=Sa\u000e,eN\u001e\u0005\u0006\r\u0002!IaR\u0001\u0010oJLG/\u001a*qG\u0006#GM]3tgR\u0019\u0001jS*\u0011\u00059I\u0015B\u0001&\u0010\u0005\u0011)f.\u001b;\t\u000b1+\u0005\u0019A'\u0002\u0007=,H\u000f\u0005\u0002O#6\tqJ\u0003\u0002Qy\u0005\u0011\u0011n\\\u0005\u0003%>\u0013\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\t\u000bQ+\u0005\u0019A\f\u0002\u0015I\u00048-\u00113ee\u0016\u001c8\u000fC\u0003W\u0001\u0011\u0005s+\u0001\u0005u_N#(/\u001b8h)\u0005A\u0006CA-a\u001d\tQf\f\u0005\u0002\\\u001f5\tAL\u0003\u0002^+\u00051AH]8pizJ!aX\b\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?>9a\u0001\u001a\u0002\t\u0002\t)\u0017A\u0004*fcV,7\u000f^'fgN\fw-\u001a\t\u0003C\u00194a!\u0001\u0002\t\u0002\t97C\u00014\u000e\u0011\u0015yc\r\"\u0001j)\u0005)\u0007\"B6g\t\u0013a\u0017A\u0004:fC\u0012\u0014\u0006oY!eIJ,7o\u001d\u000b\u0003/5DQA\u001c6A\u0002=\f!!\u001b8\u0011\u00059\u0003\u0018BA9P\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007\"B:g\t\u0003!\u0018!B1qa2LH\u0003B\u0019vm~DQ!\u0011:A\u0002\tCQa\u001e:A\u0002a\faa\u00197jK:$\bCA=~\u001b\u0005Q(BA<|\u0015\tah!A\u0004oKR<xN]6\n\u0005yT(a\u0004+sC:\u001c\bo\u001c:u\u00072LWM\u001c;\t\r\u0005\u0005!\u000f1\u00019\u0003\u0015\u0011\u0017\u0010^3t\u0001")
public class RequestMessage {
    private final RpcAddress senderAddress;
    private final NettyRpcEndpointRef receiver;
    private final Object content;

    public static RequestMessage apply(NettyRpcEnv nettyRpcEnv, TransportClient transportClient, ByteBuffer byteBuffer) {
        return RequestMessage$.MODULE$.apply(nettyRpcEnv, transportClient, byteBuffer);
    }

    public RpcAddress senderAddress() {
        return this.senderAddress;
    }

    public NettyRpcEndpointRef receiver() {
        return this.receiver;
    }

    public Object content() {
        return this.content;
    }

    public ByteBuffer serialize(NettyRpcEnv nettyEnv) {
        ByteBufferOutputStream bos = new ByteBufferOutputStream();
        try (DataOutputStream out = new DataOutputStream(bos);){
            this.writeRpcAddress(out, this.senderAddress());
            this.writeRpcAddress(out, this.receiver().address());
            out.writeUTF(this.receiver().name());
            try (SerializationStream s = nettyEnv.serializeStream(out);){
                s.writeObject(this.content(), ClassTag$.MODULE$.Any());
            }
        }
        return bos.toByteBuffer();
    }

    private void writeRpcAddress(DataOutputStream out, RpcAddress rpcAddress) {
        if (rpcAddress == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(rpcAddress.host());
            out.writeInt(rpcAddress.port());
        }
    }

    public String toString() {
        return new StringBuilder(20).append("RequestMessage(").append(this.senderAddress()).append(", ").append(this.receiver()).append(", ").append(this.content()).append(")").toString();
    }

    public RequestMessage(RpcAddress senderAddress, NettyRpcEndpointRef receiver, Object content) {
        this.senderAddress = senderAddress;
        this.receiver = receiver;
        this.content = content;
    }
}

