/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.NettyStreamManager;
import org.apache.spark.rpc.netty.OneWayOutboxMessage;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.rpc.netty.RpcOutboxMessage;
import org.apache.spark.serializer.JavaSerializerInstance;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011ea!B\u0001\u0003\u0001\ta!a\u0003(fiRL(\u000b]2F]ZT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u0001:qG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0011I!\u0001\u0005\u0003\u0003\rI\u00038-\u00128w!\t\u0011R#D\u0001\u0014\u0015\t!b!\u0001\u0005j]R,'O\\1m\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\tAaY8oM\u000e\u0001Q#A\u000e\u0011\u0005qiR\"\u0001\u0004\n\u0005y1!!C*qCJ\\7i\u001c8g\u0011!\u0001\u0003A!A!\u0002\u0013Y\u0012!B2p]\u001a\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002-)\fg/Y*fe&\fG.\u001b>fe&s7\u000f^1oG\u0016\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u0015M,'/[1mSj,'/\u0003\u0002)K\t1\"*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0011Awn\u001d;\u0011\u00051*dBA\u00174!\tq\u0013'D\u00010\u0015\t\u0001\u0014$\u0001\u0004=e>|GO\u0010\u0006\u0002e\u0005)1oY1mC&\u0011A'M\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025c!A\u0011\b\u0001B\u0001B\u0003%!(A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\ta2(\u0003\u0002=\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u00039qW/\\+tC\ndWmQ8sKN\u0004\"\u0001Q!\u000e\u0003EJ!AQ\u0019\u0003\u0007%sG\u000fC\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\u0007\r\"K%j\u0013'\u0011\u0005\u001d\u0003Q\"\u0001\u0002\t\u000ba\u0019\u0005\u0019A\u000e\t\u000b\t\u001a\u0005\u0019A\u0012\t\u000b)\u001a\u0005\u0019A\u0016\t\u000be\u001a\u0005\u0019\u0001\u001e\t\u000by\u001a\u0005\u0019A \t\u00119\u0003!\u0019!C\u0001\u0005=\u000bQ\u0002\u001e:b]N\u0004xN\u001d;D_:4W#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T!!\u0016\u0004\u0002\u000f9,Go^8sW&\u0011qK\u0015\u0002\u000e)J\fgn\u001d9peR\u001cuN\u001c4\t\re\u0003\u0001\u0015!\u0003Q\u00039!(/\u00198ta>\u0014HoQ8oM\u0002Bqa\u0017\u0001C\u0002\u0013%A,\u0001\u0006eSN\u0004\u0018\r^2iKJ,\u0012!\u0018\t\u0003\u000fzK!a\u0018\u0002\u0003\u0015\u0011K7\u000f]1uG\",'\u000f\u0003\u0004b\u0001\u0001\u0006I!X\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b\u0005C\u0004d\u0001\t\u0007I\u0011\u00023\u0002\u001bM$(/Z1n\u001b\u0006t\u0017mZ3s+\u0005)\u0007CA$g\u0013\t9'A\u0001\nOKR$\u0018p\u0015;sK\u0006lW*\u00198bO\u0016\u0014\bBB5\u0001A\u0003%Q-\u0001\btiJ,\u0017-\\'b]\u0006<WM\u001d\u0011\t\u000f-\u0004!\u0019!C\u0005Y\u0006\u0001BO]1ogB|'\u000f^\"p]R,\u0007\u0010^\u000b\u0002[B\u0011an\\\u0007\u0002)&\u0011\u0001\u000f\u0016\u0002\u0011)J\fgn\u001d9peR\u001cuN\u001c;fqRDaA\u001d\u0001!\u0002\u0013i\u0017!\u0005;sC:\u001c\bo\u001c:u\u0007>tG/\u001a=uA!)A\u000f\u0001C\u0005k\u000612M]3bi\u0016\u001cE.[3oi\n{w\u000e^:ue\u0006\u00048\u000fF\u0001w!\r980`\u0007\u0002q*\u00111+\u001f\u0006\u0002u\u0006!!.\u0019<b\u0013\ta\bP\u0001\u0003MSN$\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002Q\u000baa\u00197jK:$\u0018bAA\u0003\u007f\nABK]1ogB|'\u000f^\"mS\u0016tGOQ8piN$(/\u00199\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0011!D2mS\u0016tGOR1di>\u0014\u00180\u0006\u0002\u0002\u000eA\u0019a0a\u0004\n\u0007\u0005EqP\u0001\fUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\r\u0006\u001cGo\u001c:z\u0011!\t)\u0002\u0001Q\u0001\n\u00055\u0011AD2mS\u0016tGOR1di>\u0014\u0018\u0010\t\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY!A\ngS2,Gi\\<oY>\fGMR1di>\u0014\u0018\u0010C\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0011a\u00064jY\u0016$un\u001e8m_\u0006$g)Y2u_JLx\fJ3r)\u0011\t\t#a\n\u0011\u0007\u0001\u000b\u0019#C\u0002\u0002&E\u0012A!\u00168ji\"Q\u0011\u0011FA\u000e\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0013\u0007C\u0006\u0002.\u0001\u0001\r\u0011!Q!\n\u00055\u0011\u0001\u00064jY\u0016$un\u001e8m_\u0006$g)Y2u_JL\b\u0005\u000b\u0003\u0002,\u0005E\u0002c\u0001!\u00024%\u0019\u0011QG\u0019\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\u0002!QLW.Z8viN\u001b\u0007.\u001a3vY\u0016\u0014XCAA\u001f!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"q\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u001d\u0013\u0011\t\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002CA&\u0001\u0001\u0006I!!\u0010\u0002#QLW.Z8viN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0005\u0003\u0006\u0002P\u0001\u0011\r\u0011\"\u0001\u0003\u0003#\n\u0001d\u00197jK:$8i\u001c8oK\u000e$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s+\t\t\u0019\u0006\u0005\u0003\u0002@\u0005U\u0013\u0002BA,\u0003\u0003\u0012!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\"A\u00111\f\u0001!\u0002\u0013\t\u0019&A\rdY&,g\u000e^\"p]:,7\r^5p]\u0016CXmY;u_J\u0004\u0003bCA0\u0001\u0001\u0007\t\u0019!C\u0005\u0003C\naa]3sm\u0016\u0014XCAA2!\u0011\t)'!\u001b\u000e\u0005\u0005\u001d$bAA0)&!\u00111NA4\u0005=!&/\u00198ta>\u0014HoU3sm\u0016\u0014\bbCA8\u0001\u0001\u0007\t\u0019!C\u0005\u0003c\n!b]3sm\u0016\u0014x\fJ3r)\u0011\t\t#a\u001d\t\u0015\u0005%\u0012QNA\u0001\u0002\u0004\t\u0019\u0007C\u0006\u0002x\u0001\u0001\r\u0011!Q!\n\u0005\r\u0014aB:feZ,'\u000f\t\u0015\u0005\u0003k\n\t\u0004C\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002\u0000\u000591\u000f^8qa\u0016$WCAAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0003\na!\u0019;p[&\u001c\u0017\u0002BAF\u0003\u000b\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CAH\u0001\u0001\u0006I!!!\u0002\u0011M$x\u000e\u001d9fI\u0002B\u0011\"a%\u0001\u0005\u0004%I!!&\u0002\u0011=,HOY8yKN,\"!a&\u0011\u0011\u0005}\u0012\u0011TAO\u0003GKA!a'\u0002B\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u00079\ty*C\u0002\u0002\"\u0012\u0011!B\u00159d\u0003\u0012$'/Z:t!\r9\u0015QU\u0005\u0004\u0003O\u0013!AB(vi\n|\u0007\u0010\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAL\u0003%yW\u000f\u001e2pq\u0016\u001c\b\u0005\u0003\u0005\u00020\u0002!\tAAAY\u00031\u0011X-\\8wK>+HOY8y)\u0011\t\t#a-\t\u0011\u0005U\u0016Q\u0016a\u0001\u0003;\u000bq!\u00193ee\u0016\u001c8\u000fC\u0004\u0002:\u0002!\t!a/\u0002\u0017M$\u0018M\u001d;TKJ4XM\u001d\u000b\u0007\u0003C\ti,!1\t\u000f\u0005}\u0016q\u0017a\u0001W\u0005Y!-\u001b8e\u0003\u0012$'/Z:t\u0011\u001d\t\u0019-a.A\u0002}\nA\u0001]8si\"Q\u0011Q\u0017\u0001\t\u0006\u0004%\t%a2\u0016\u0005\u0005u\u0005\u0006BAc\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.\u0001\u0006b]:|G/\u0019;j_:T!!!6\u0002\u000b)\fg/\u0019=\n\t\u0005e\u0017q\u001a\u0002\t\u001dVdG.\u00192mK\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0017!D:fiV\u0004XI\u001c3q_&tG\u000f\u0006\u0004\u0002b\u0006\u001d\u00181\u001e\t\u0004\u001d\u0005\r\u0018bAAs\t\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007bBAu\u00037\u0004\raK\u0001\u0005]\u0006lW\r\u0003\u0005\u0002n\u0006m\u0007\u0019AAx\u0003!)g\u000e\u001a9pS:$\bc\u0001\b\u0002r&\u0019\u00111\u001f\u0003\u0003\u0017I\u00038-\u00128ea>Lg\u000e\u001e\u0005\b\u0003o\u0004A\u0011AA}\u0003i\t7/\u001f8d'\u0016$X\u000f]#oIB|\u0017N\u001c;SK\u001a\u0014\u00150\u0016*J)\u0011\tYP!\u0002\u0011\r\u0005u(\u0011AAq\u001b\t\tyPC\u0002\u0002DEJAAa\u0001\u0002\u0000\n1a)\u001e;ve\u0016DqAa\u0002\u0002v\u0002\u00071&A\u0002ve&DqAa\u0003\u0001\t\u0003\u0012i!\u0001\u0003ti>\u0004H\u0003BA\u0011\u0005\u001fA\u0001B!\u0005\u0003\n\u0001\u0007\u0011\u0011]\u0001\fK:$\u0007o\\5oiJ+g\rC\u0004\u0003\u0016\u0001!IAa\u0006\u0002\u0019A|7\u000f\u001e+p\u001fV$(m\u001c=\u0015\r\u0005\u0005\"\u0011\u0004B\u0012\u0011!\u0011YBa\u0005A\u0002\tu\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u0011\u0007\u001d\u0013y\"C\u0002\u0003\"\t\u00111CT3uif\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001aD\u0001B!\n\u0003\u0014\u0001\u0007!qE\u0001\b[\u0016\u001c8/Y4f!\r9%\u0011F\u0005\u0004\u0005W\u0011!!D(vi\n|\u00070T3tg\u0006<W\r\u0003\u0005\u00030\u0001!\tA\u0001B\u0019\u0003\u0011\u0019XM\u001c3\u0015\t\u0005\u0005\"1\u0007\u0005\t\u0005K\u0011i\u00031\u0001\u00036A\u0019qIa\u000e\n\u0007\te\"A\u0001\bSKF,Xm\u001d;NKN\u001c\u0018mZ3\t\u0011\tu\u0002\u0001\"\u0001\u0003\u0005\u007f\tAb\u0019:fCR,7\t\\5f]R$BA!\u0011\u0003HA\u0019aPa\u0011\n\u0007\t\u0015sPA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011!\t)La\u000fA\u0002\u0005u\u0005\u0002\u0003B&\u0001\u0011\u0005!A!\u0014\u0002\u0007\u0005\u001c8.\u0006\u0003\u0003P\teCC\u0002B)\u0005w\u0012i\b\u0006\u0003\u0003T\t-\u0004CBA\u007f\u0005\u0003\u0011)\u0006\u0005\u0003\u0003X\teC\u0002\u0001\u0003\t\u00057\u0012IE1\u0001\u0003^\t\tA+\u0005\u0003\u0003`\t\u0015\u0004c\u0001!\u0003b%\u0019!1M\u0019\u0003\u000f9{G\u000f[5oOB\u0019\u0001Ia\u001a\n\u0007\t%\u0014GA\u0002B]fD!B!\u001c\u0003J\u0005\u0005\t9\u0001B8\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005c\u00129H!\u0016\u000e\u0005\tM$b\u0001B;c\u00059!/\u001a4mK\u000e$\u0018\u0002\u0002B=\u0005g\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\t\u0005K\u0011I\u00051\u0001\u00036!A!q\u0010B%\u0001\u0004\u0011\t)A\u0004uS6,w.\u001e;\u0011\u00079\u0011\u0019)C\u0002\u0003\u0006\u0012\u0011!B\u00159d)&lWm\\;u\u0011!\u0011I\t\u0001C\u0001\u0005\t-\u0015!C:fe&\fG.\u001b>f)\u0011\u0011iI!'\u0011\t\t=%QS\u0007\u0003\u0005#S1Aa%z\u0003\rq\u0017n\\\u0005\u0005\u0005/\u0013\tJ\u0001\u0006CsR,')\u001e4gKJD\u0001Ba'\u0003\b\u0002\u0007!QM\u0001\bG>tG/\u001a8u\u0011!\u0011y\n\u0001C\u0001\u0005\t\u0005\u0016aD:fe&\fG.\u001b>f'R\u0014X-Y7\u0015\t\t\r&\u0011\u0016\t\u0004I\t\u0015\u0016b\u0001BTK\t\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\"A!1\u0016BO\u0001\u0004\u0011i+A\u0002pkR\u0004BAa,\u000366\u0011!\u0011\u0017\u0006\u0004\u0005gK\u0018AA5p\u0013\u0011\u00119L!-\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u0011\tm\u0006\u0001\"\u0001\u0003\u0005{\u000b1\u0002Z3tKJL\u0017\r\\5{KV!!q\u0018Bc)\u0019\u0011\tM!4\u0003PR!!1\u0019Bd!\u0011\u00119F!2\u0005\u0011\tm#\u0011\u0018b\u0001\u0005;B!B!3\u0003:\u0006\u0005\t9\u0001Bf\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0005c\u00129Ha1\t\u0011\u0005\u0005!\u0011\u0018a\u0001\u0005\u0003B\u0001B!5\u0003:\u0002\u0007!QR\u0001\u0006Ef$Xm\u001d\u0005\b\u0005#\u0001A\u0011\tBk)\u0011\t\tOa6\t\u0011\u00055(1\u001ba\u0001\u0003_DqAa7\u0001\t\u0003\u0012i.\u0001\u0005tQV$Hm\\<o)\t\t\t\u0003C\u0004\u0003b\u0002!\tE!8\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007b\u0002Bs\u0001\u0011%!Q\\\u0001\bG2,\u0017M\\;q\u0011\u001d\u0011Y\f\u0001C!\u0005S,BAa;\u0003pR!!Q\u001eBy!\u0011\u00119Fa<\u0005\u0011\tm#q\u001db\u0001\u0005;B\u0001Ba=\u0003h\u0002\u0007!Q_\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0015\u0001%q\u001fBw\u0013\r\u0011I0\r\u0002\n\rVt7\r^5p]BBqA!@\u0001\t\u0003\u0012y0\u0001\u0006gS2,7+\u001a:wKJ,\"a!\u0001\u0011\u00079\u0019\u0019!C\u0002\u0004\u0006\u0011\u0011\u0001C\u00159d\u000b:4h)\u001b7f'\u0016\u0014h/\u001a:\t\u000f\r%\u0001\u0001\"\u0011\u0004\f\u0005Yq\u000e]3o\u0007\"\fgN\\3m)\u0011\u0019ia!\u0007\u0011\t\r=1QC\u0007\u0003\u0007#QAaa\u0005\u0003\u0012\u0006A1\r[1o]\u0016d7/\u0003\u0003\u0004\u0018\rE!a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007b\u0002B\u0004\u0007\u000f\u0001\ra\u000b\u0005\b\u0007;\u0001A\u0011BB\u0010\u00039!wn\u001e8m_\u0006$7\t\\5f]R$bA!\u0011\u0004\"\r\r\u0002B\u0002\u0016\u0004\u001c\u0001\u00071\u0006C\u0004\u0002D\u000em\u0001\u0019A \u0007\r\r\u001d\u0002\u0001BB\u0015\u0005M1\u0015\u000e\\3E_^tGn\\1e\u0007\"\fgN\\3m'\u0019\u0019)ca\u000b\u0004\u000eA!1QFB\u001a\u001b\t\u0019yCC\u0002\u00042e\fA\u0001\\1oO&!1QGB\u0018\u0005\u0019y%M[3di\"Y1\u0011HB\u0013\u0005\u0003\u0005\u000b\u0011BB\u001e\u0003\u0019\u0019x.\u001e:dKB!1QHB\"\u001d\u0011\u0019yaa\u0010\n\t\r\u00053\u0011C\u0001\u0005!&\u0004X-\u0003\u0003\u0004F\r\u001d#!D*pkJ\u001cWm\u00115b]:,GN\u0003\u0003\u0004B\rE\u0001b\u0002#\u0004&\u0011\u000511\n\u000b\u0005\u0007\u001b\u001a\t\u0006\u0005\u0003\u0004P\r\u0015R\"\u0001\u0001\t\u0011\re2\u0011\na\u0001\u0007wAAb!\u0016\u0004&\u0001\u0007\t\u0019!C\u0005\u0007/\nQ!\u001a:s_J,\"a!\u0017\u0011\t\rm3Q\r\b\u0005\u0007;\u001a\tGD\u0002/\u0007?J\u0011AM\u0005\u0004\u0007G\n\u0014a\u00029bG.\fw-Z\u0005\u0005\u0007O\u001aIGA\u0005UQJ|w/\u00192mK*\u001911M\u0019\t\u0019\r54Q\u0005a\u0001\u0002\u0004%Iaa\u001c\u0002\u0013\u0015\u0014(o\u001c:`I\u0015\fH\u0003BA\u0011\u0007cB!\"!\u000b\u0004l\u0005\u0005\t\u0019AB-\u00111\u0019)h!\nA\u0002\u0003\u0005\u000b\u0015BB-\u0003\u0019)'O]8sA!\"11OA\u0019\u0011!\u0019Yh!\n\u0005\u0002\ru\u0014\u0001C:fi\u0016\u0013(o\u001c:\u0015\t\u0005\u00052q\u0010\u0005\t\u0007\u0003\u001bI\b1\u0001\u0004Z\u0005\tQ\r\u0003\u0005\u0004\u0006\u000e\u0015B\u0011IBD\u0003\u0011\u0011X-\u00193\u0015\u0007}\u001aI\t\u0003\u0005\u0004\f\u000e\r\u0005\u0019\u0001BG\u0003\r!7\u000f\u001e\u0005\t\u0007\u001f\u001b)\u0003\"\u0011\u0003^\u0006)1\r\\8tK\"A11SB\u0013\t\u0003\u001a)*\u0001\u0004jg>\u0003XM\u001c\u000b\u0003\u0007/\u00032\u0001QBM\u0013\r\u0019Y*\r\u0002\b\u0005>|G.Z1o\r\u0019\u0019y\n\u0001\u0003\u0004\"\n!b)\u001b7f\t><h\u000e\\8bI\u000e\u000bG\u000e\u001c2bG.\u001cba!(\u0004,\r\r\u0006c\u0001@\u0004&&\u00191qU@\u0003\u001dM#(/Z1n\u0007\u0006dGNY1dW\"Y11VBO\u0005\u0003\u0005\u000b\u0011BBW\u0003\u0011\u0019\u0018N\\6\u0011\t\r=1qV\u0005\u0005\u0007c\u001b\tBA\nXe&$\u0018M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0006\u0004:\ru%\u0011!Q\u0001\n\r5\u0003bCA\u0001\u0007;\u0013\t\u0011)A\u0005\u0005\u0003Bq\u0001RBO\t\u0003\u0019I\f\u0006\u0005\u0004<\u000eu6qXBa!\u0011\u0019ye!(\t\u0011\r-6q\u0017a\u0001\u0007[C\u0001b!\u000f\u00048\u0002\u00071Q\n\u0005\t\u0003\u0003\u00199\f1\u0001\u0003B!A1QYBO\t\u0003\u001a9-\u0001\u0004p]\u0012\u000bG/\u0019\u000b\u0007\u0003C\u0019Im!4\t\u000f\r-71\u0019a\u0001W\u0005A1\u000f\u001e:fC6LE\r\u0003\u0005\u0004P\u000e\r\u0007\u0019\u0001BG\u0003\r\u0011WO\u001a\u0005\t\u0007'\u001ci\n\"\u0011\u0004V\u0006QqN\\\"p[BdW\r^3\u0015\t\u0005\u00052q\u001b\u0005\b\u0007\u0017\u001c\t\u000e1\u0001,\u0011!\u0019Yn!(\u0005B\ru\u0017!C8o\r\u0006LG.\u001e:f)\u0019\t\tca8\u0004b\"911ZBm\u0001\u0004Y\u0003\u0002CBr\u00073\u0004\ra!\u0017\u0002\u000b\r\fWo]3\b\u0011\r\u001d(\u0001#\u0001\u0003\u0007S\f1BT3uif\u0014\u0006oY#omB\u0019qia;\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0004nN)11^Bx#A\u0019\u0001i!=\n\u0007\rM\u0018G\u0001\u0004B]f\u0014VM\u001a\u0005\b\t\u000e-H\u0011AB|)\t\u0019I\u000fC\u0006\u0004|\u000e-(\u0019!C\u0001\u0005\ru\u0018AC2veJ,g\u000e^#omV\u00111q \t\u0006\t\u0003!)AR\u0007\u0003\t\u0007Q!aU\u0019\n\t\u0011\u001dA1\u0001\u0002\u0010\tft\u0017-\\5d-\u0006\u0014\u0018.\u00192mK\"IA1BBvA\u0003%1q`\u0001\fGV\u0014(/\u001a8u\u000b:4\b\u0005C\u0006\u0005\u0010\r-(\u0019!C\u0001\u0005\u0011E\u0011!D2veJ,g\u000e^\"mS\u0016tG/\u0006\u0002\u0005\u0014A1A\u0011\u0001C\u0003\u0005\u0003B\u0011\u0002b\u0006\u0004l\u0002\u0006I\u0001b\u0005\u0002\u001d\r,(O]3oi\u000ec\u0017.\u001a8uA\u0001")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    @Nullable
    private RpcAddress address;
    private final SparkConf conf;
    private final JavaSerializerInstance javaSerializerInstance;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private final NettyStreamManager streamManager;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private volatile TransportClientFactory fileDownloadFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private NettyStreamManager streamManager() {
        return this.streamManager;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        return this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new AuthClientBootstrap(this.transportConf(), this.securityManager.getSaslUser(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private TransportClientFactory fileDownloadFactory() {
        return this.fileDownloadFactory;
    }

    private void fileDownloadFactory_$eq(TransportClientFactory x$1) {
        this.fileDownloadFactory = x$1;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        block0: {
            Outbox outbox = this.outboxes().remove(address);
            if (outbox == null) break block0;
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new AuthServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(bindAddress, port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() != null ? new RpcAddress(this.host, this.server().getPort()) : null;
                this.bitmap$0 = true;
            }
        }
        this.host = null;
        return this.address;
    }

    @Override
    public RpcAddress address() {
        return !this.bitmap$0 ? this.address$lzycompute() : this.address;
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1 & Serializable & scala.Serializable)find -> NettyRpcEnv.$anonfun$asyncSetupEndpointRefByURI$1(uri, endpointRef, BoxesRunTime.unboxToBoolean((Object)find)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot send message to client endpoint with no listen address.");
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
            }
            catch (RpcEnvStoppedException e) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    NettyRpcEnv.$anonfun$ask$4(this, promise, x0$1);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                    this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
                    return BoxedUnit.UNIT;
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(client, response) -> {
                    this.onSuccess$1(this.deserialize(client, response, ClassTag$.MODULE$.Any()), promise);
                    return BoxedUnit.UNIT;
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    NettyRpcEnv.$anonfun$ask$7(rpcMessage, x0$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise, remoteAddr){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;
                private final RpcAddress remoteAddr$1;

                public void run() {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder(31).append("Cannot receive any reply from ").append(this.remoteAddr$1).append(" ").append(new StringBuilder(3).append("in ").append(this.timeout$1.duration()).toString()).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                    this.remoteAddr$1 = remoteAddr$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)timeoutCancelable.cancel(true)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e2, promise);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0 & Serializable & scala.Serializable)() -> this.deserialize((Function0 & Serializable & scala.Serializable)() -> $this.javaSerializerInstance.deserialize(bytes, evidence$2)));
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        block5: {
            if (!this.stopped().compareAndSet(false, true)) {
                return;
            }
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() != null ? this.timeoutScheduler().shutdownNow() : BoxedUnit.UNIT;
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            Object object2 = this.clientConnectionExecutor() != null ? this.clientConnectionExecutor().shutdownNow() : BoxedUnit.UNIT;
            if (this.fileDownloadFactory() == null) break block5;
            this.fileDownloadFactory().close();
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcEnvFileServer fileServer() {
        return this.streamManager();
    }

    @Override
    public ReadableByteChannel openChannel(String uri) {
        URI parsedUri = new URI(uri);
        Predef$.MODULE$.require(parsedUri.getHost() != null, (Function0 & Serializable & scala.Serializable)() -> "Host name must be defined.");
        Predef$.MODULE$.require(parsedUri.getPort() > 0, (Function0 & Serializable & scala.Serializable)() -> "Port must be defined.");
        Predef$.MODULE$.require(parsedUri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(parsedUri.getPath())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Path must be defined.");
        Pipe pipe = Pipe.open();
        FileDownloadChannel source = new FileDownloadChannel(this, pipe.source());
        JFunction0.mcV.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TransportClient client = this.downloadClient(parsedUri.getHost(), parsedUri.getPort());
            FileDownloadCallback callback = new FileDownloadCallback(this, pipe.sink(), source, client);
            client.stream(parsedUri.getPath(), (StreamCallback)callback);
        };
        JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            pipe.sink().close();
            source.close();
        };
        JFunction0.mcV.sp & Serializable & scala.Serializable x$3 = () -> NettyRpcEnv.$anonfun$openChannel$6((Function0)x$1);
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks(x$1, (Function0<BoxedUnit>)x$2, (Function0<BoxedUnit>)x$3);
        return source;
    }

    private TransportClient downloadClient(String host, int port) {
        if (this.fileDownloadFactory() == null) {
            NettyRpcEnv nettyRpcEnv = this;
            synchronized (nettyRpcEnv) {
                if (this.fileDownloadFactory() == null) {
                    String module = "files";
                    String prefix = "spark.rpc.io.";
                    SparkConf clone = this.conf().clone();
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.conf().getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Object object;
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            if (key.startsWith(prefix)) {
                                String opt = key.substring(prefix.length());
                                object = clone.setIfMissing(new StringBuilder(10).append("spark.").append(module).append(".io.").append(opt).toString(), value);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        BoxedUnit boxedUnit = object;
                        return boxedUnit;
                    });
                    int ioThreads = clone.getInt("spark.files.io.threads", 1);
                    TransportConf downloadConf = SparkTransportConf$.MODULE$.fromSparkConf(clone, module, ioThreads);
                    TransportContext downloadContext = new TransportContext(downloadConf, (RpcHandler)new NoOpRpcHandler(), true);
                    this.fileDownloadFactory_$eq(downloadContext.createClientFactory(this.createClientBootstraps()));
                }
            }
        }
        return this.fileDownloadFactory().createClient(host, port);
    }

    public static final /* synthetic */ Future $anonfun$asyncSetupEndpointRefByURI$1(String uri$1, NettyRpcEndpointRef endpointRef$1, boolean find) {
        return find ? Future$.MODULE$.successful((Object)endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(uri$1));
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        block2: {
            if (promise$1.tryFailure(e)) break block2;
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(rpcEnvStoppedException).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(e).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private final void onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (!promise$1.trySuccess(object)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored message: ").append(reply).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$ask$4(NettyRpcEnv $this, Promise promise$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object response = success.value();
            $this.onSuccess$1(response, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$ask$7(RpcOutboxMessage rpcMessage$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof TimeoutException) {
            rpcMessage$1.onTimeout();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$openChannel$6(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1$1);
    }

    public NettyRpcEnv(SparkConf conf, JavaSerializerInstance javaSerializerInstance, String host, SecurityManager securityManager, int numUsableCores) {
        this.conf = conf;
        this.javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.rpc.io.numConnectionsPerPeer", "1"), "rpc", conf.getInt("spark.rpc.io.threads", numUsableCores));
        this.dispatcher = new Dispatcher(this, numUsableCores);
        this.streamManager = new NettyStreamManager(this);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this, this.streamManager()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }

    public class FileDownloadCallback
    implements StreamCallback {
        private final WritableByteChannel sink;
        private final FileDownloadChannel source;
        public final /* synthetic */ NettyRpcEnv $outer;

        public void onData(String streamId, ByteBuffer buf) {
            while (buf.remaining() > 0) {
                this.sink.write(buf);
            }
        }

        public void onComplete(String streamId) {
            this.sink.close();
        }

        public void onFailure(String streamId, Throwable cause) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Error downloading stream ").append(streamId).append(".").toString(), cause);
            this.source.setError(cause);
            this.sink.close();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer() {
            return this.$outer;
        }

        public FileDownloadCallback(NettyRpcEnv $outer, WritableByteChannel sink, FileDownloadChannel source, TransportClient client) {
            this.sink = sink;
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class FileDownloadChannel
    implements ReadableByteChannel {
        private final Pipe.SourceChannel source;
        private volatile Throwable error;
        public final /* synthetic */ NettyRpcEnv $outer;

        private Throwable error() {
            return this.error;
        }

        private void error_$eq(Throwable x$1) {
            this.error = x$1;
        }

        public void setError(Throwable e) {
            this.error_$eq(e);
        }

        @Override
        public int read(ByteBuffer dst) {
            int bytesRead;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.source.read(dst));
            if (this.error() != null) {
                throw this.error();
            }
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable readErr = failure.exception();
                    throw readErr;
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            int n = bytesRead = BoxesRunTime.unboxToInt((Object)success.value());
            return n;
        }

        @Override
        public void close() {
            this.source.close();
        }

        @Override
        public boolean isOpen() {
            return this.source.isOpen();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer() {
            return this.$outer;
        }

        public FileDownloadChannel(NettyRpcEnv $outer, Pipe.SourceChannel source) {
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

