/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.netty.Inbox;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.LocalNettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcMessage;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.concurrent.Promise;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5b!B\u0001\u0003\u0001\ta!A\u0003#jgB\fGo\u00195fe*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t1A\u001d9d\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\u0005oKR$\u00180\u00128w\u0007\u0001\u0001\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003\u00179+G\u000f^=Sa\u000e,eN\u001e\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005qa.^7Vg\u0006\u0014G.Z\"pe\u0016\u001c\bC\u0001\b$\u0013\t!sBA\u0002J]RDQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDc\u0001\u0015*UA\u0011Q\u0004\u0001\u0005\u00065\u0015\u0002\r\u0001\b\u0005\u0006C\u0015\u0002\rA\t\u0004\u0005Y\u0001!QF\u0001\u0007F]\u0012\u0004x.\u001b8u\t\u0006$\u0018m\u0005\u0002,\u001b!Aqf\u000bBC\u0002\u0013\u0005\u0001'\u0001\u0003oC6,W#A\u0019\u0011\u0005IJdBA\u001a8!\t!t\"D\u00016\u0015\t14$\u0001\u0004=e>|GOP\u0005\u0003q=\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001h\u0004\u0005\t{-\u0012\t\u0011)A\u0005c\u0005)a.Y7fA!Aqh\u000bBC\u0002\u0013\u0005\u0001)\u0001\u0005f]\u0012\u0004x.\u001b8u+\u0005\t\u0005C\u0001\"D\u001b\u0005!\u0011B\u0001#\u0005\u0005-\u0011\u0006oY#oIB|\u0017N\u001c;\t\u0011\u0019[#\u0011!Q\u0001\n\u0005\u000b\u0011\"\u001a8ea>Lg\u000e\u001e\u0011\t\u0011![#Q1A\u0005\u0002%\u000b1A]3g+\u0005Q\u0005CA\u000fL\u0013\ta%AA\nOKR$\u0018P\u00159d\u000b:$\u0007o\\5oiJ+g\r\u0003\u0005OW\t\u0005\t\u0015!\u0003K\u0003\u0011\u0011XM\u001a\u0011\t\u000b\u0019ZC\u0011\u0001)\u0015\tE\u001bF+\u0016\t\u0003%.j\u0011\u0001\u0001\u0005\u0006_=\u0003\r!\r\u0005\u0006\u007f=\u0003\r!\u0011\u0005\u0006\u0011>\u0003\rA\u0013\u0005\b/.\u0012\r\u0011\"\u0001Y\u0003\u0015IgNY8y+\u0005I\u0006CA\u000f[\u0013\tY&AA\u0003J]\n|\u0007\u0010\u0003\u0004^W\u0001\u0006I!W\u0001\u0007S:\u0014w\u000e\u001f\u0011\t\u000f}\u0003!\u0019!C\u0005A\u0006IQM\u001c3q_&tGo]\u000b\u0002CB!!-[\u0019R\u001b\u0005\u0019'B\u00013f\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003M\u001e\fA!\u001e;jY*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016d\u00055\u0019uN\\2veJ,g\u000e^'ba\"1A\u000e\u0001Q\u0001\n\u0005\f!\"\u001a8ea>Lg\u000e^:!\u0011\u001dq\u0007A1A\u0005\n=\fA\"\u001a8ea>Lg\u000e\u001e*fMN,\u0012\u0001\u001d\t\u0005E&\f\u0015\u000f\u0005\u0002Ce&\u00111\u000f\u0002\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011\u0019)\b\u0001)A\u0005a\u0006iQM\u001c3q_&tGOU3gg\u0002Bqa\u001e\u0001C\u0002\u0013%\u00010A\u0005sK\u000e,\u0017N^3sgV\t\u0011\u0010E\u0002cuFK!a_2\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\t\ru\u0004\u0001\u0015!\u0003z\u0003)\u0011XmY3jm\u0016\u00148\u000f\t\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002\u000591\u000f^8qa\u0016$WCAA\u0002!\rq\u0011QA\u0005\u0004\u0003\u000fy!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0017\u0001\u0001\u0019!C\u0005\u0003\u001b\t1b\u001d;paB,Gm\u0018\u0013fcR!\u0011qBA\u000b!\rq\u0011\u0011C\u0005\u0004\u0003'y!\u0001B+oSRD!\"a\u0006\u0002\n\u0005\u0005\t\u0019AA\u0002\u0003\rAH%\r\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\u0004\u0005A1\u000f^8qa\u0016$\u0007\u0005\u000b\u0005\u0002\u001a\u0005}\u0011\u0011GA\u001a!\u0011\t\t#!\f\u000e\u0005\u0005\r\"b\u00013\u0002&)!\u0011qEA\u0015\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003W\tQA[1wCbLA!a\f\u0002$\tIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003k\tA\u0001\u001e5jg\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012a\u0005:fO&\u001cH/\u001a:Sa\u000e,e\u000e\u001a9pS:$H#\u0002&\u0002>\u0005}\u0002BB\u0018\u00028\u0001\u0007\u0011\u0007\u0003\u0004@\u0003o\u0001\r!\u0011\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003E9W\r\u001e*qG\u0016sG\r]8j]R\u0014VM\u001a\u000b\u0004c\u0006\u001d\u0003BB \u0002B\u0001\u0007\u0011\tC\u0004\u0002L\u0001!\t!!\u0014\u0002)I,Wn\u001c<f%B\u001cWI\u001c3q_&tGOU3g)\u0011\ty!a\u0014\t\r}\nI\u00051\u0001B\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+\nQ#\u001e8sK\u001eL7\u000f^3s%B\u001cWI\u001c3q_&tG\u000f\u0006\u0003\u0002\u0010\u0005]\u0003BB\u0018\u0002R\u0001\u0007\u0011\u0007C\u0004\u0002\\\u0001!\t!!\u0018\u0002\tM$x\u000e\u001d\u000b\u0005\u0003\u001f\ty\u0006C\u0004\u0002b\u0005e\u0003\u0019A9\u0002\u001dI\u00048-\u00128ea>Lg\u000e\u001e*fM\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014!\u00039pgR$v.\u00117m)\u0011\ty!!\u001b\t\u0011\u0005-\u00141\ra\u0001\u0003[\nq!\\3tg\u0006<W\rE\u0002\u001e\u0003_J1!!\u001d\u0003\u00051IeNY8y\u001b\u0016\u001c8/Y4f\u0011\u001d\t)\b\u0001C\u0001\u0003o\n\u0011\u0003]8tiJ+Wn\u001c;f\u001b\u0016\u001c8/Y4f)\u0019\ty!!\u001f\u0002\u0002\"A\u00111NA:\u0001\u0004\tY\bE\u0002\u001e\u0003{J1!a \u0003\u00059\u0011V-];fgRlUm]:bO\u0016D\u0001\"a!\u0002t\u0001\u0007\u0011QQ\u0001\tG\u0006dGNY1dWB!\u0011qQAI\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015AB2mS\u0016tGOC\u0002\u0002\u0010\u001a\tqA\\3uo>\u00148.\u0003\u0003\u0002\u0014\u0006%%a\u0005*qGJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007bBAL\u0001\u0011\u0005\u0011\u0011T\u0001\u0011a>\u001cH\u000fT8dC2lUm]:bO\u0016$b!a\u0004\u0002\u001c\u0006u\u0005\u0002CA6\u0003+\u0003\r!a\u001f\t\u0011\u0005}\u0015Q\u0013a\u0001\u0003C\u000b\u0011\u0001\u001d\t\u0007\u0003G\u000b9+a+\u000e\u0005\u0005\u0015&B\u00013\u0010\u0013\u0011\tI+!*\u0003\u000fA\u0013x.\\5tKB\u0019a\"!,\n\u0007\u0005=vBA\u0002B]fDq!a-\u0001\t\u0003\t),A\tq_N$xJ\\3XCflUm]:bO\u0016$B!a\u0004\u00028\"A\u00111NAY\u0001\u0004\tY\bC\u0004\u0002<\u0002!I!!0\u0002\u0017A|7\u000f^'fgN\fw-\u001a\u000b\t\u0003\u001f\ty,a1\u0002F\"9\u0011\u0011YA]\u0001\u0004\t\u0014\u0001D3oIB|\u0017N\u001c;OC6,\u0007\u0002CA6\u0003s\u0003\r!!\u001c\t\u0011\u0005\u001d\u0017\u0011\u0018a\u0001\u0003\u0013\f\u0011cY1mY\n\f7m[%g'R|\u0007\u000f]3e!\u001dq\u00111ZAh\u0003\u001fI1!!4\u0010\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002R\u0006mg\u0002BAj\u0003/t1\u0001NAk\u0013\u0005\u0001\u0012bAAm\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BAo\u0003?\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005ew\u0002C\u0004\u0002\\\u0001!\t!a9\u0015\u0005\u0005=\u0001bBAt\u0001\u0011\u0005\u00111]\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:Dq!a;\u0001\t\u0003\ti/\u0001\u0004wKJLg-\u001f\u000b\u0005\u0003\u0007\ty\u000f\u0003\u00040\u0003S\u0004\r!\r\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003k\f!\u0002\u001e5sK\u0006$\u0007o\\8m+\t\t9\u0010E\u0002c\u0003sL1!a?d\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\t\u0011\u0005}\b\u0001)A\u0005\u0003o\f1\u0002\u001e5sK\u0006$\u0007o\\8mA\u00191!1\u0001\u0001\u0005\u0005\u000b\u00111\"T3tg\u0006<W\rT8paN1!\u0011\u0001B\u0004\u0005'\u0001BA!\u0003\u0003\u00105\u0011!1\u0002\u0006\u0004\u0005\u001b9\u0017\u0001\u00027b]\u001eLAA!\u0005\u0003\f\t1qJ\u00196fGR\u0004BA!\u0003\u0003\u0016%!!q\u0003B\u0006\u0005!\u0011VO\u001c8bE2,\u0007b\u0002\u0014\u0003\u0002\u0011\u0005!1\u0004\u000b\u0003\u0005;\u00012A\u0015B\u0001\u0011!\u0011\tC!\u0001\u0005B\u0005\r\u0018a\u0001:v]\"I!Q\u0005\u0001C\u0002\u0013%!qE\u0001\u000b!>L7o\u001c8QS2dW#A)\t\u000f\t-\u0002\u0001)A\u0005#\u0006Y\u0001k\\5t_:\u0004\u0016\u000e\u001c7!\u0001")
public class Dispatcher
implements Logging {
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentMap<String, EndpointData> endpoints;
    private final ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers;
    @GuardedBy(value="this")
    private boolean stopped;
    private final ThreadPoolExecutor threadpool;
    private final EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<String, EndpointData> endpoints() {
        return this.endpoints;
    }

    private ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    public LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$receivers;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.conf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                throw new IllegalStateException("RpcEnv has been stopped");
            }
            if (this.endpoints().putIfAbsent(name, new EndpointData(this, name, endpoint, endpointRef)) != null) {
                throw new IllegalArgumentException(new StringBuilder(39).append("There is already an RpcEndpoint called ").append(name).toString());
            }
            EndpointData data = (EndpointData)this.endpoints().get(name);
            this.endpointRefs().put(data.endpoint(), data.ref());
            this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
        }
        return endpointRef;
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return (RpcEndpointRef)this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    private void unregisterRpcEndpoint(String name) {
        block0: {
            EndpointData data = (EndpointData)this.endpoints().remove(name);
            if (data == null) break block0;
            data.inbox().stop();
            this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                Dispatcher.$anonfun$postToAll$1(this, message, e);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            callback.onFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            p.tryFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    private void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Some some;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Some some2;
            EndpointData data = (EndpointData)this.endpoints().get(endpointName);
            if (this.stopped()) {
                some2 = new Some((Object)new RpcEnvStoppedException());
            } else if (data == null) {
                some2 = new Some((Object)new SparkException(new StringBuilder(16).append("Could not find ").append(endpointName).append(".").toString()));
            } else {
                data.inbox().post(message);
                this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
                some2 = None$.MODULE$;
            }
            some = some2;
        }
        Some error = some;
        error.foreach(callbackIfStopped);
    }

    public void stop() {
        block4: {
            Dispatcher dispatcher = this;
            synchronized (dispatcher) {
                block3: {
                    if (this.stopped()) break block3;
                    this.stopped_$eq(true);
                    break block4;
                }
                return;
            }
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.endpoints().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)name -> {
            this.unregisterRpcEndpoint(name);
            return BoxedUnit.UNIT;
        });
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
        this.threadpool().shutdown();
    }

    public void awaitTermination() {
        this.threadpool().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    private ThreadPoolExecutor threadpool() {
        return this.threadpool;
    }

    public EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    }

    public static final /* synthetic */ void $anonfun$postToAll$1(Dispatcher $this, InboxMessage message$1, Exception e) {
        Exception exception = e;
        if (exception instanceof RpcEnvStoppedException) {
            RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)exception;
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(rpcEnvStoppedException.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (exception != null) {
            Exception exception2 = exception;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(exception2.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)exception);
        }
    }

    public Dispatcher(NettyRpcEnv nettyEnv, int numUsableCores) {
        this.nettyEnv = nettyEnv;
        Logging.$init$(this);
        this.endpoints = new ConcurrentHashMap<String, EndpointData>();
        this.endpointRefs = new ConcurrentHashMap<RpcEndpoint, RpcEndpointRef>();
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers = new LinkedBlockingQueue();
        this.stopped = false;
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        int numThreads = nettyEnv.conf().getInt("spark.rpc.netty.dispatcher.numThreads", package$.MODULE$.max(2, availableCores));
        ThreadPoolExecutor pool = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, "dispatcher-event-loop");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> pool.execute(new MessageLoop()));
        this.threadpool = pool;
        this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill = new EndpointData(this, null, null, null);
    }

    public class EndpointData {
        private final String name;
        private final RpcEndpoint endpoint;
        private final NettyRpcEndpointRef ref;
        private final Inbox inbox;
        public final /* synthetic */ Dispatcher $outer;

        public String name() {
            return this.name;
        }

        public RpcEndpoint endpoint() {
            return this.endpoint;
        }

        public NettyRpcEndpointRef ref() {
            return this.ref;
        }

        public Inbox inbox() {
            return this.inbox;
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$EndpointData$$$outer() {
            return this.$outer;
        }

        public EndpointData(Dispatcher $outer, String name, RpcEndpoint endpoint, NettyRpcEndpointRef ref) {
            this.name = name;
            this.endpoint = endpoint;
            this.ref = ref;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.inbox = new Inbox(ref, endpoint);
        }
    }

    public class MessageLoop
    implements Runnable {
        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        try {
                            EndpointData data;
                            EndpointData endpointData = data = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().take();
                            EndpointData endpointData2 = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill();
                            if (!(endpointData != null ? !endpointData.equals(endpointData2) : endpointData2 != null)) {
                                this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
                                return;
                            }
                            data.inbox().process(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer());
                            continue block4;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = (Throwable)option.get();
                                this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            throw throwable;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer() {
            return Dispatcher.this;
        }

        public MessageLoop() {
            if (Dispatcher.this == null) {
                throw null;
            }
        }
    }
}

