/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t\u0019b*\u001a;us\ncwnY6Sa\u000e\u001cVM\u001d<fe*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\tqA\\3uo>\u00148N\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\t\tB!\u0001\u0004tKJ4XM]\u0005\u0003'A\u0011!B\u00159d\u0011\u0006tG\r\\3s!\t)\u0002$D\u0001\u0017\u0015\t9b!\u0001\u0005j]R,'O\\1m\u0013\tIbCA\u0004M_\u001e<\u0017N\\4\t\u0011m\u0001!\u0011!Q\u0001\nq\tQ!\u00199q\u0013\u0012\u0004\"!\b\u0014\u000f\u0005y!\u0003CA\u0010#\u001b\u0005\u0001#BA\u0011\r\u0003\u0019a$o\\8u})\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\u00051\u0001K]3eK\u001aL!a\n\u0015\u0003\rM#(/\u001b8h\u0015\t)#\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003)\u0019XM]5bY&TXM\u001d\t\u0003Y9j\u0011!\f\u0006\u0003U\u0019I!aL\u0017\u0003\u0015M+'/[1mSj,'\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s!\t\u0019D'D\u0001\u0005\u0013\t)DA\u0001\tCY>\u001c7\u000eR1uC6\u000bg.Y4fe\")q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"B!O\u001e={A\u0011!\bA\u0007\u0002\u0005!)1D\u000ea\u00019!)!F\u000ea\u0001W!)\u0011G\u000ea\u0001e!9q\b\u0001b\u0001\n\u0013\u0001\u0015!D:ue\u0016\fW.T1oC\u001e,'/F\u0001B!\ty!)\u0003\u0002D!\t1rJ\\3G_J|e.Z*ue\u0016\fW.T1oC\u001e,'\u000f\u0003\u0004F\u0001\u0001\u0006I!Q\u0001\u000fgR\u0014X-Y7NC:\fw-\u001a:!\u0011\u00159\u0005\u0001\"\u0011I\u0003\u001d\u0011XmY3jm\u0016$B!S'U=B\u0011!jS\u0007\u0002E%\u0011AJ\t\u0002\u0005+:LG\u000fC\u0003O\r\u0002\u0007q*\u0001\u0004dY&,g\u000e\u001e\t\u0003!Jk\u0011!\u0015\u0006\u0003\u001d\u0012I!aU)\u0003\u001fQ\u0013\u0018M\\:q_J$8\t\\5f]RDQ!\u0016$A\u0002Y\u000b!B\u001d9d\u001b\u0016\u001c8/Y4f!\t9F,D\u0001Y\u0015\tI&,A\u0002oS>T\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b}3\u0005\u0019\u00011\u0002\u001fI,7\u000f]8og\u0016\u001cuN\u001c;fqR\u0004\"\u0001U1\n\u0005\t\f&a\u0005*qGJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007\"\u00023\u0001\t\u0003*\u0017!\u0004:fG\u0016Lg/Z*ue\u0016\fW\u000e\u0006\u0003gS*d\u0007C\u0001)h\u0013\tA\u0017K\u0001\u000bTiJ,\u0017-\\\"bY2\u0014\u0017mY6XSRD\u0017\n\u0012\u0005\u0006\u001d\u000e\u0004\ra\u0014\u0005\u0006W\u000e\u0004\rAV\u0001\u000e[\u0016\u001c8/Y4f\u0011\u0016\fG-\u001a:\t\u000b}\u001b\u0007\u0019\u00011\t\u000b9\u0004A\u0011I8\u0002!\u001d,Go\u0015;sK\u0006lW*\u00198bO\u0016\u0014H#\u00019\u0011\u0005=\t\u0018B\u0001:\u0011\u00055\u0019FO]3b[6\u000bg.Y4fe\u0002")
public class NettyBlockRpcServer
extends RpcHandler
implements Logging {
    private final String appId;
    private final Serializer serializer;
    private final BlockDataManager blockManager;
    private final OneForOneStreamManager streamManager;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private OneForOneStreamManager streamManager() {
        return this.streamManager;
    }

    public void receive(TransportClient client, ByteBuffer rpcMessage, RpcResponseCallback responseContext) {
        block3: {
            BlockTransferMessage blockTransferMessage;
            block4: {
                StorageLevel storageLevel;
                ClassTag classTag;
                UploadBlock uploadBlock;
                block6: {
                    Tuple2 tuple2;
                    block5: {
                        block2: {
                            BlockTransferMessage message = BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)rpcMessage);
                            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Received request: ").append(message).toString());
                            blockTransferMessage = message;
                            if (!(blockTransferMessage instanceof OpenBlocks)) break block2;
                            OpenBlocks openBlocks = (OpenBlocks)blockTransferMessage;
                            int blocksNum = openBlocks.blockIds.length;
                            SeqView blocks = (SeqView)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), blocksNum).view().map((Function1 & Serializable & scala.Serializable)i -> this.blockManager.getBlockData(BlockId$.MODULE$.apply(openBlocks.blockIds[BoxesRunTime.unboxToInt((Object)i)])), SeqView$.MODULE$.canBuildFrom());
                            long streamId = this.streamManager().registerStream(this.appId, (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(blocks.iterator()).asJava());
                            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Registered streamId ").append(streamId).append(" with ").append(blocksNum).append(" buffers").toString());
                            responseContext.onSuccess(new StreamHandle(streamId, blocksNum).toByteBuffer());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(blockTransferMessage instanceof UploadBlock)) break block4;
                        uploadBlock = (UploadBlock)blockTransferMessage;
                        tuple2 = (Tuple2)this.serializer.newInstance().deserialize(ByteBuffer.wrap(uploadBlock.metadata), ClassTag$.MODULE$.Nothing());
                        if (tuple2 == null) break block5;
                        StorageLevel level = (StorageLevel)tuple2._1();
                        classTag = (ClassTag)tuple2._2();
                        if (level == null) break block5;
                        storageLevel = level;
                        if (classTag instanceof ClassTag) break block6;
                    }
                    throw new MatchError((Object)tuple2);
                }
                ClassTag classTag2 = classTag;
                Tuple2 tuple2 = new Tuple2((Object)storageLevel, (Object)classTag2);
                Tuple2 tuple22 = tuple2;
                StorageLevel level = (StorageLevel)tuple22._1();
                ClassTag classTag3 = (ClassTag)tuple22._2();
                NioManagedBuffer data = new NioManagedBuffer(ByteBuffer.wrap(uploadBlock.blockData));
                BlockId blockId = BlockId$.MODULE$.apply(uploadBlock.blockId);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Receiving replicated block ").append(blockId).append(" with level ").append(level).append(" ").append(new StringBuilder(5).append("from ").append(client.getSocketAddress()).toString()).toString());
                this.blockManager.putBlockData(blockId, (ManagedBuffer)data, level, classTag3);
                responseContext.onSuccess(ByteBuffer.allocate(0));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                break block3;
            }
            throw new MatchError((Object)blockTransferMessage);
        }
    }

    public StreamCallbackWithID receiveStream(TransportClient client, ByteBuffer messageHeader, RpcResponseCallback responseContext) {
        StorageLevel storageLevel;
        ClassTag classTag;
        UploadBlockStream message;
        block3: {
            Tuple2 tuple2;
            block2: {
                message = (UploadBlockStream)BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)messageHeader);
                tuple2 = (Tuple2)this.serializer.newInstance().deserialize(ByteBuffer.wrap(message.metadata), ClassTag$.MODULE$.Nothing());
                if (tuple2 == null) break block2;
                StorageLevel level = (StorageLevel)tuple2._1();
                classTag = (ClassTag)tuple2._2();
                if (level == null) break block2;
                storageLevel = level;
                if (classTag instanceof ClassTag) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        ClassTag classTag2 = classTag;
        Tuple2 tuple2 = new Tuple2((Object)storageLevel, (Object)classTag2);
        Tuple2 tuple22 = tuple2;
        StorageLevel level = (StorageLevel)tuple22._1();
        ClassTag classTag3 = (ClassTag)tuple22._2();
        BlockId blockId = BlockId$.MODULE$.apply(message.blockId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Receiving replicated block ").append(blockId).append(" with level ").append(level).append(" as stream ").append(new StringBuilder(5).append("from ").append(client.getSocketAddress()).toString()).toString());
        return this.blockManager.putBlockDataAsStream(blockId, level, classTag3);
    }

    public StreamManager getStreamManager() {
        return this.streamManager();
    }

    public NettyBlockRpcServer(String appId, Serializer serializer, BlockDataManager blockManager) {
        this.appId = appId;
        this.serializer = serializer;
        this.blockManager = blockManager;
        Logging.$init$(this);
        this.streamManager = new OneForOneStreamManager();
    }
}

