/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.metrics.MetricsConfig;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.MetricsServlet;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.metrics.source.StaticSources$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0001\u0011Q!!D'fiJL7m]*zgR,WN\u0003\u0002\u0004\t\u00059Q.\u001a;sS\u000e\u001c(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003-M\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003!Ign\u001d;b]\u000e,7\u0001A\u000b\u00027A\u0011Ad\t\b\u0003;\u0005\u0002\"AH\u0007\u000e\u0003}Q!\u0001I\r\u0002\rq\u0012xn\u001c;?\u0013\t\u0011S\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012\u000e\u0011!9\u0003A!A!\u0002\u0013Y\u0012!C5ogR\fgnY3!\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001B2p]\u001a\u0004\"a\u000b\u0017\u000e\u0003\u0011I!!\f\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0017M,7-\u001e:jifluM\u001d\t\u0003WEJ!A\r\u0003\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJDQ\u0001\u000e\u0001\u0005\nU\na\u0001P5oSRtD\u0003\u0002\u001c9si\u0002\"a\u000e\u0001\u000e\u0003\tAQ\u0001G\u001aA\u0002mAQ!K\u001aA\u0002)BQaL\u001aA\u0002ABa\u0001\u0010\u0001!\u0002\u0013i\u0014!D7fiJL7m]\"p]\u001aLw\r\u0005\u00028}%\u0011qH\u0001\u0002\u000e\u001b\u0016$(/[2t\u0007>tg-[4\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u0006)1/\u001b8lgV\t1\tE\u0002E\u0013.k\u0011!\u0012\u0006\u0003\r\u001e\u000bq!\\;uC\ndWM\u0003\u0002I\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)+%aC!se\u0006L()\u001e4gKJ\u0004\"\u0001T(\u000e\u00035S!A\u0014\u0002\u0002\tMLgn[\u0005\u0003!6\u0013AaU5oW\"1!\u000b\u0001Q\u0001\n\r\u000baa]5oWN\u0004\u0003b\u0002+\u0001\u0005\u0004%I!V\u0001\bg>,(oY3t+\u00051\u0006c\u0001#J/B\u0011\u0001lW\u0007\u00023*\u0011!LA\u0001\u0007g>,(oY3\n\u0005qK&AB*pkJ\u001cW\r\u0003\u0004_\u0001\u0001\u0006IAV\u0001\tg>,(oY3tA!9\u0001\r\u0001b\u0001\n\u0013\t\u0017\u0001\u0003:fO&\u001cHO]=\u0016\u0003\t\u0004\"aY5\u000e\u0003\u0011T!aA3\u000b\u0005\u0019<\u0017\u0001C2pI\u0006D\u0017\r\\3\u000b\u0003!\f1aY8n\u0013\tQGM\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\t\r1\u0004\u0001\u0015!\u0003c\u0003%\u0011XmZ5tiJL\b\u0005C\u0004o\u0001\u0001\u0007I\u0011B8\u0002\u000fI,hN\\5oOV\t\u0001\u000f\u0005\u0002\rc&\u0011!/\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d!\b\u00011A\u0005\nU\f1B];o]&twm\u0018\u0013fcR\u0011a/\u001f\t\u0003\u0019]L!\u0001_\u0007\u0003\tUs\u0017\u000e\u001e\u0005\buN\f\t\u00111\u0001q\u0003\rAH%\r\u0005\u0007y\u0002\u0001\u000b\u0015\u00029\u0002\u0011I,hN\\5oO\u0002BqA \u0001A\u0002\u0013%q0\u0001\bnKR\u0014\u0018nY:TKJ4H.\u001a;\u0016\u0005\u0005\u0005\u0001#\u0002\u0007\u0002\u0004\u0005\u001d\u0011bAA\u0003\u001b\t1q\n\u001d;j_:\u00042\u0001TA\u0005\u0013\r\tY!\u0014\u0002\u000f\u001b\u0016$(/[2t'\u0016\u0014h\u000f\\3u\u0011%\ty\u0001\u0001a\u0001\n\u0013\t\t\"\u0001\nnKR\u0014\u0018nY:TKJ4H.\u001a;`I\u0015\fHc\u0001<\u0002\u0014!I!0!\u0004\u0002\u0002\u0003\u0007\u0011\u0011\u0001\u0005\t\u0003/\u0001\u0001\u0015)\u0003\u0002\u0002\u0005yQ.\u001a;sS\u000e\u001c8+\u001a:wY\u0016$\b\u0005C\u0004\u0002\u001c\u0001!\t!!\b\u0002%\u001d,GoU3sm2,G\u000fS1oI2,'o]\u000b\u0003\u0003?\u0001R\u0001DA\u0011\u0003KI1!a\t\u000e\u0005\u0015\t%O]1z!\u0011\t9#!\u000e\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tqa]3sm2,GO\u0003\u0003\u00020\u0005E\u0012!\u00026fiRL(bAA\u001a\u0011\u00059Qm\u00197jaN,\u0017\u0002BA\u001c\u0003S\u0011QcU3sm2,GoQ8oi\u0016DH\u000fS1oI2,'\u000fC\u0004\u0002<\u0001!\t!!\u0010\u0002\u000bM$\u0018M\u001d;\u0015\u0003YDq!!\u0011\u0001\t\u0003\ti$\u0001\u0003ti>\u0004\bbBA#\u0001\u0011\u0005\u0011QH\u0001\u0007e\u0016\u0004xN\u001d;\t\u0011\u0005%\u0003\u0001\"\u0001\u0005\u0003\u0017\n\u0011CY;jY\u0012\u0014VmZ5tiJLh*Y7f)\rY\u0012Q\n\u0005\u00075\u0006\u001d\u0003\u0019A,\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u0005\u0001r-\u001a;T_V\u00148-Z:Cs:\u000bW.\u001a\u000b\u0005\u0003+\n9\u0007E\u0003\u0002X\u0005\u0005tK\u0004\u0003\u0002Z\u0005ucb\u0001\u0010\u0002\\%\ta\"C\u0002\u0002`5\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$aA*fc*\u0019\u0011qL\u0007\t\u000f\u0005%\u0014q\na\u00017\u0005Q1o\\;sG\u0016t\u0015-\\3\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005q!/Z4jgR,'oU8ve\u000e,Gc\u0001<\u0002r!1!,a\u001bA\u0002]Cq!!\u001e\u0001\t\u0003\t9(\u0001\u0007sK6|g/Z*pkJ\u001cW\rF\u0002w\u0003sBaAWA:\u0001\u00049\u0006bBA?\u0001\u0011%\u0011QH\u0001\u0010e\u0016<\u0017n\u001d;feN{WO]2fg\"9\u0011\u0011\u0011\u0001\u0005\n\u0005u\u0012!\u0004:fO&\u001cH/\u001a:TS:\\7o\u0002\u0005\u0002\u0006\nA\t\u0001BAD\u00035iU\r\u001e:jGN\u001c\u0016p\u001d;f[B\u0019q'!#\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0002\fN\u0019\u0011\u0011R\u0006\t\u000fQ\nI\t\"\u0001\u0002\u0010R\u0011\u0011q\u0011\u0005\u000b\u0003'\u000bII1A\u0005\u0002\u0005U\u0015AC*J\u001d.{&+R$F1V\u0011\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003!i\u0017\r^2iS:<'bAAQ\u001b\u0005!Q\u000f^5m\u0013\u0011\t)+a'\u0003\u000bI+w-\u001a=\t\u0013\u0005%\u0016\u0011\u0012Q\u0001\n\u0005]\u0015aC*J\u001d.{&+R$F1\u0002B!\"!,\u0002\n\n\u0007I\u0011AAK\u00031\u0019v*\u0016*D\u000b~\u0013ViR#Y\u0011%\t\t,!#!\u0002\u0013\t9*A\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005\f\t\u0005\n\u0003k\u000bI\t)A\u0005\u0003o\u000b\u0011#T%O\u00136\u000bEj\u0018)P\u00192{VKT%U!\u0011\tI,!2\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\t+!1\u000b\u0005\u0005\r\u0017\u0001\u00026bm\u0006LA!a2\u0002<\nAA+[7f+:LG\u000fC\u0005\u0002L\u0006%\u0005\u0015!\u0003\u0002N\u0006\u0019R*\u0013(J\u001b\u0006cu\fU(M\u0019~\u0003VIU%P\tB\u0019A\"a4\n\u0007\u0005EWBA\u0002J]RD\u0001\"!6\u0002\n\u0012\u0005\u0011q[\u0001\u001aG\",7m['j]&l\u0017\r\u001c)pY2Lgn\u001a)fe&|G\rF\u0003w\u00033\fi\u000e\u0003\u0005\u0002\\\u0006M\u0007\u0019AA\\\u0003!\u0001x\u000e\u001c7V]&$\b\u0002CAp\u0003'\u0004\r!!4\u0002\u0015A|G\u000e\u001c)fe&|G\r\u0003\u0005\u0002d\u0006%E\u0011AAs\u0003M\u0019'/Z1uK6+GO]5dgNK8\u000f^3n)\u001d1\u0014q]Au\u0003WDa\u0001GAq\u0001\u0004Y\u0002BB\u0015\u0002b\u0002\u0007!\u0006\u0003\u00040\u0003C\u0004\r\u0001\r")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final SparkConf conf;
    private final SecurityManager securityMgr;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private boolean running;
    private Option<MetricsServlet> metricsServlet;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MetricsSystem createMetricsSystem(String string, SparkConf sparkConf, SecurityManager securityManager) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, sparkConf, securityManager);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String instance() {
        return this.instance;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private Option<MetricsServlet> metricsServlet() {
        return this.metricsServlet;
    }

    private void metricsServlet_$eq(Option<MetricsServlet> x$1) {
        this.metricsServlet = x$1;
    }

    public ServletContextHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletContextHandler[])this.metricsServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class)));
    }

    public void start() {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        StaticSources$.MODULE$.allSources().foreach((Function1 & Serializable & scala.Serializable)source -> {
            this.registerSource(source);
            return BoxedUnit.UNIT;
        });
        this.registerSources();
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.start();
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.report();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildRegistryName(Source source) {
        String string;
        String defaultName;
        block7: {
            Option<String> executorId;
            Option metricsNamespace;
            block6: {
                metricsNamespace = ((Option)this.conf.get(package$.MODULE$.METRICS_NAMESPACE())).orElse((Function0 & Serializable & scala.Serializable)() -> $this.conf.getOption("spark.app.id"));
                executorId = this.conf.getOption("spark.executor.id");
                defaultName = MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
                String string2 = this.instance();
                String string3 = "driver";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block6;
                String string4 = this.instance();
                String string5 = "executor";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
            }
            if (metricsNamespace.isDefined() && executorId.isDefined()) {
                string = MetricRegistry.name((String)((String)metricsNamespace.get()), (String[])new String[]{(String)executorId.get(), source.sourceName()});
                return string;
            }
            if (metricsNamespace.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Using default name ").append(defaultName).append(" for source because neither ").append(new StringBuilder(25).append(package$.MODULE$.METRICS_NAMESPACE().key()).append(" nor spark.app.id is set.").toString()).toString());
            }
            if (executorId.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Using default name ").append(defaultName).append(" for source because spark.executor.id is ").append("not set.").toString());
            }
            string = defaultName;
            return string;
        }
        string = defaultName;
        return string;
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return (Seq)this.sources().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$5)));
    }

    public void registerSource(Source source) {
        this.sources().$plus$eq((Object)source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().$minus$eq((Object)source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                try {
                    Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), $this.securityMgr);
                    Object object = kv._1();
                    String string = "servlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        this.metricsServlet_$eq((Option<MetricsServlet>)new Some((Object)((MetricsServlet)sink)));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = this.sinks().$plus$eq((Object)((Sink)sink));
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$5) {
        String string = x$5.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).newInstance();
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, SparkConf conf, SecurityManager securityMgr) {
        this.instance = instance;
        this.conf = conf;
        this.securityMgr = securityMgr;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.running = false;
        this.metricsServlet = None$.MODULE$;
        this.metricsConfig.initialize();
    }
}

