/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0001\u0003\u0001\u0011Q!!D'fiJL7m]\"p]\u001aLwM\u0003\u0002\u0004\t\u00059Q.\u001a;sS\u000e\u001c(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003-M\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u00111\u0004H\u0007\u0002\t%\u0011Q\u0004\u0002\u0002\n'B\f'o[\"p]\u001aDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDCA\u0011$!\t\u0011\u0003!D\u0001\u0003\u0011\u0015Ab\u00041\u0001\u001b\u0011\u001d)\u0003A1A\u0005\n\u0019\na\u0002R#G\u0003VcEk\u0018)S\u000b\u001aK\u0005,F\u0001(!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003mC:<'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012aa\u0015;sS:<\u0007B\u0002\u0019\u0001A\u0003%q%A\bE\u000b\u001a\u000bU\u000b\u0014+`!J+e)\u0013-!\u0011\u001d\u0011\u0004A1A\u0005\nM\na\"\u0013(T)\u0006s5)R0S\u000b\u001e+\u0005,F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\tIT\"\u0001\u0003vi&d\u0017BA\u001e7\u0005\u0015\u0011VmZ3y\u0011\u0019i\u0004\u0001)A\u0005i\u0005y\u0011JT*U\u0003:\u001bUi\u0018*F\u000f\u0016C\u0006\u0005C\u0004@\u0001\t\u0007I\u0011\u0002\u0014\u0002;\u0011+e)Q+M)~kU\t\u0016*J\u0007N{6i\u0014(G?\u001aKE*\u0012(B\u001b\u0016Ca!\u0011\u0001!\u0002\u00139\u0013A\b#F\r\u0006+F\nV0N\u000bR\u0013\u0016jQ*`\u0007>sei\u0018$J\u0019\u0016s\u0015)T#!\u0011!\u0019\u0005A1A\u0005\u0002\t!\u0015A\u00039s_B,'\u000f^5fgV\tQ\t\u0005\u0002G\u00116\tqI\u0003\u0002:W%\u0011\u0011j\u0012\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB&\u0001A\u0003%Q)A\u0006qe>\u0004XM\u001d;jKN\u0004\u0003\u0002C'\u0001\u0001\u0004%\tA\u0001(\u00021A,'/\u00138ti\u0006t7-Z*vEB\u0013x\u000e]3si&,7/F\u0001P!\u0011\u0001VkV#\u000e\u0003ES!AU*\u0002\u000f5,H/\u00192mK*\u0011A+D\u0001\u000bG>dG.Z2uS>t\u0017B\u0001,R\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.\u000e\u001b\u0005Y&B\u0001/\u001a\u0003\u0019a$o\\8u}%\u0011a,D\u0001\u0007!J,G-\u001a4\n\u00059\u0002'B\u00010\u000e\u0011!\u0011\u0007\u00011A\u0005\u0002\t\u0019\u0017\u0001\b9fe&s7\u000f^1oG\u0016\u001cVO\u0019)s_B,'\u000f^5fg~#S-\u001d\u000b\u0003I\u001e\u0004\"\u0001D3\n\u0005\u0019l!\u0001B+oSRDq\u0001[1\u0002\u0002\u0003\u0007q*A\u0002yIEBaA\u001b\u0001!B\u0013y\u0015!\u00079fe&s7\u000f^1oG\u0016\u001cVO\u0019)s_B,'\u000f^5fg\u0002BQ\u0001\u001c\u0001\u0005\n5\fAc]3u\t\u00164\u0017-\u001e7u!J|\u0007/\u001a:uS\u0016\u001cHC\u00013o\u0011\u0015y7\u000e1\u0001F\u0003\u0011\u0001(o\u001c9\t\u000bE\u0004A\u0011\u0001:\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001e\u0011\u0015!\b\u0001\"\u0001v\u00035\u0019XO\u0019)s_B,'\u000f^5fgR\u0019qJ^<\t\u000b=\u001c\b\u0019A#\t\u000ba\u001c\b\u0019\u0001\u001b\u0002\u000bI,w-\u001a=\t\u000bi\u0004A\u0011A>\u0002\u0017\u001d,G/\u00138ti\u0006t7-\u001a\u000b\u0003\u000brDQ!`=A\u0002]\u000bA!\u001b8ti\"9q\u0010\u0001Q\u0005\n\u0005\u0005\u0011A\u00067pC\u0012\u0004&o\u001c9feRLWm\u001d$s_64\u0015\u000e\\3\u0015\u0007\u0011\f\u0019\u0001C\u0004\u0002\u0006y\u0004\r!a\u0002\u0002\tA\fG\u000f\u001b\t\u0005\u0019\u0005%q+C\u0002\u0002\f5\u0011aa\u00149uS>t\u0007")
public class MetricsConfig
implements Logging {
    private final SparkConf conf;
    private final String DEFAULT_PREFIX;
    private final Regex INSTANCE_REGEX;
    private final String DEFAULT_METRICS_CONF_FILENAME;
    private final Properties properties;
    private HashMap<String, Properties> perInstanceSubProperties;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String DEFAULT_PREFIX() {
        return this.DEFAULT_PREFIX;
    }

    private Regex INSTANCE_REGEX() {
        return this.INSTANCE_REGEX;
    }

    private String DEFAULT_METRICS_CONF_FILENAME() {
        return this.DEFAULT_METRICS_CONF_FILENAME;
    }

    public Properties properties() {
        return this.properties;
    }

    public HashMap<String, Properties> perInstanceSubProperties() {
        return this.perInstanceSubProperties;
    }

    public void perInstanceSubProperties_$eq(HashMap<String, Properties> x$1) {
        this.perInstanceSubProperties = x$1;
    }

    private void setDefaultProperties(Properties prop) {
        prop.setProperty("*.sink.servlet.class", "org.apache.spark.metrics.sink.MetricsServlet");
        prop.setProperty("*.sink.servlet.path", "/metrics/json");
        prop.setProperty("master.sink.servlet.path", "/metrics/master/json");
        prop.setProperty("applications.sink.servlet.path", "/metrics/applications/json");
    }

    public void initialize() {
        block0: {
            this.setDefaultProperties(this.properties());
            this.loadPropertiesFromFile(this.conf.getOption("spark.metrics.conf"));
            String prefix = "spark.metrics.conf.";
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.conf.getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var3_8;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    if (k.startsWith(prefix)) {
                        Object object = this.properties().setProperty(k.substring(prefix.length()), v);
                        return var3_8;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var3_8;
            });
            this.perInstanceSubProperties_$eq(this.subProperties(this.properties(), this.INSTANCE_REGEX()));
            if (!this.perInstanceSubProperties().contains((Object)this.DEFAULT_PREFIX())) break block0;
            Map defaultSubProperties = (Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.perInstanceSubProperties().apply((Object)this.DEFAULT_PREFIX())).asScala();
            this.perInstanceSubProperties().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig.$anonfun$initialize$2(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig.$anonfun$initialize$3(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                MetricsConfig.$anonfun$initialize$4(defaultSubProperties, x$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, Properties> subProperties(Properties prop, Regex regex) {
        void var3_3;
        HashMap subProperties = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(prop).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            Object object;
            if (regex.findPrefixOf((CharSequence)((String)kv._1()).toString()).isDefined()) {
                String string = ((String)kv._1()).toString();
                Option option = regex.unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)string);
                }
                String prefix = (String)((LinearSeqOptimized)option.get()).apply(0);
                String suffix = (String)((LinearSeqOptimized)option.get()).apply(1);
                Tuple2 tuple2 = new Tuple2((Object)prefix, (Object)suffix);
                Tuple2 tuple22 = tuple2;
                String prefix2 = (String)tuple22._1();
                String suffix2 = (String)tuple22._2();
                object = ((Properties)subProperties.getOrElseUpdate((Object)prefix2, (Function0 & Serializable & scala.Serializable)() -> new Properties())).setProperty(suffix2, ((String)kv._2()).toString());
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return var3_3;
    }

    public Properties getInstance(String inst) {
        Properties properties;
        Option option = this.perInstanceSubProperties().get((Object)inst);
        if (option instanceof Some) {
            Properties s;
            Some some = (Some)option;
            properties = s = (Properties)some.value();
        } else if (None$.MODULE$.equals(option)) {
            properties = (Properties)this.perInstanceSubProperties().getOrElse((Object)this.DEFAULT_PREFIX(), (Function0 & Serializable & scala.Serializable)() -> new Properties());
        } else {
            throw new MatchError((Object)option);
        }
        return properties;
    }

    private void loadPropertiesFromFile(Option<String> path) {
        try (InputStream is = null;){
            try {
                InputStream inputStream;
                Option<String> option = path;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String f = (String)some.value();
                    inputStream = new FileInputStream(f);
                } else if (None$.MODULE$.equals(option)) {
                    inputStream = Utils$.MODULE$.getSparkClassLoader().getResourceAsStream(this.DEFAULT_METRICS_CONF_FILENAME());
                } else {
                    throw new MatchError(option);
                }
                is = inputStream;
                if (is != null) {
                    this.properties().load(is);
                }
            }
            catch (Exception e) {
                String file = (String)path.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.DEFAULT_METRICS_CONF_FILENAME());
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error loading configuration file ").append(file).toString(), e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$initialize$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$initialize$3(MetricsConfig $this, Tuple2 x$1) {
        String instance;
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = instance = (String)tuple2._1();
        String string2 = $this.DEFAULT_PREFIX();
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$initialize$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$initialize$6(Properties prop$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = prop$1.get(k) == null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialize$4(Map defaultSubProperties$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Properties prop = (Properties)tuple2._2();
        defaultSubProperties$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig.$anonfun$initialize$5(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig.$anonfun$initialize$6(prop, x$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = prop.put(k, v);
            return object;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MetricsConfig(SparkConf conf) {
        this.conf = conf;
        Logging.$init$(this);
        this.DEFAULT_PREFIX = "*";
        this.INSTANCE_REGEX = new StringOps(Predef$.MODULE$.augmentString("^(\\*|[a-zA-Z]+)\\.(.+)")).r();
        this.DEFAULT_METRICS_CONF_FILENAME = "metrics.properties";
        this.properties = new Properties();
        this.perInstanceSubProperties = null;
    }
}

