/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.UnifiedMemoryManager;
import scala.Predef$;
import scala.runtime.RichDouble$;

public final class UnifiedMemoryManager$ {
    public static UnifiedMemoryManager$ MODULE$;
    private final int RESERVED_SYSTEM_MEMORY_BYTES;

    static {
        new UnifiedMemoryManager$();
    }

    private int RESERVED_SYSTEM_MEMORY_BYTES() {
        return this.RESERVED_SYSTEM_MEMORY_BYTES;
    }

    public UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        long maxMemory = this.getMaxMemory(conf);
        return new UnifiedMemoryManager(conf, maxMemory, (long)((double)maxMemory * conf.getDouble("spark.memory.storageFraction", 0.5)), numCores);
    }

    private long getMaxMemory(SparkConf conf) {
        long executorMemory;
        long reservedMemory;
        long minSystemMemory;
        long systemMemory = conf.getLong("spark.testing.memory", Runtime.getRuntime().maxMemory());
        if (systemMemory < (minSystemMemory = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)(reservedMemory = conf.getLong("spark.testing.reservedMemory", conf.contains("spark.testing") ? 0L : (long)this.RESERVED_SYSTEM_MEMORY_BYTES())) * 1.5)))) {
            throw new IllegalArgumentException(new StringBuilder(73).append("System memory ").append(systemMemory).append(" must ").append(new StringBuilder(66).append("be at least ").append(minSystemMemory).append(". Please increase heap size using the --driver-memory ").toString()).append("option or spark.driver.memory in Spark configuration.").toString());
        }
        if (conf.contains("spark.executor.memory") && (executorMemory = conf.getSizeAsBytes("spark.executor.memory")) < minSystemMemory) {
            throw new IllegalArgumentException(new StringBuilder(107).append("Executor memory ").append(executorMemory).append(" must be at least ").append(new StringBuilder(44).append(minSystemMemory).append(". Please increase executor memory using the ").toString()).append("--executor-memory option or spark.executor.memory in Spark configuration.").toString());
        }
        long usableMemory = systemMemory - reservedMemory;
        double memoryFraction = conf.getDouble("spark.memory.fraction", 0.6);
        return (long)((double)usableMemory * memoryFraction);
    }

    private UnifiedMemoryManager$() {
        MODULE$ = this;
        this.RESERVED_SYSTEM_MEMORY_BYTES = 314572800;
    }
}

