/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.MemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.memory.MemoryStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\u0001\u0003\u0001\tQ!!E*u_J\fw-Z'f[>\u0014\u0018\u0010U8pY*\u00111\u0001B\u0001\u0007[\u0016lwN]=\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0010!\taQ\"D\u0001\u0003\u0013\tq!A\u0001\u0006NK6|'/\u001f)p_2\u0004\"\u0001E\n\u000e\u0003EQ!A\u0005\u0003\u0002\u0011%tG/\u001a:oC2L!\u0001F\t\u0003\u000f1{wmZ5oO\"Aa\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0003m_\u000e\\7\u0001\u0001\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019y%M[3di\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0006nK6|'/_'pI\u0016\u0004\"\u0001D\u0012\n\u0005\u0011\u0012!AC'f[>\u0014\u00180T8eK\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"2\u0001K\u0015+!\ta\u0001\u0001C\u0003\u0017K\u0001\u0007\u0001\u0004C\u0003\"K\u0001\u0007!\u0005\u0003\u0004-\u0001\u0001\u0006I!L\u0001\ta>|GNT1nKB\u0011af\u000e\b\u0003_U\u0002\"\u0001M\u001a\u000e\u0003ER!AM\f\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001a\u0004BB\u001e\u0001A\u0003&A(A\u0006`[\u0016lwN]=Vg\u0016$\u0007CA\u001f?\u001b\u0005\u0019\u0014BA 4\u0005\u0011auN\\4)\ti\n5\n\u0014\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000b!bY8oGV\u0014(/\u001a8u\u0015\t1u)\u0001\u0006b]:|G/\u0019;j_:T\u0011\u0001S\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0015\u000e\u0013\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003YAQA\u0014\u0001\u0005B=\u000b!\"\\3n_JLXk]3e+\u0005a\u0004\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0003S\u00031yV.Z7pef\u001cFo\u001c:f+\u0005\u0019\u0006C\u0001+Y\u001b\u0005)&BA\u0002W\u0015\t9F!A\u0004ti>\u0014\u0018mZ3\n\u0005e+&aC'f[>\u0014\u0018p\u0015;pe\u0016D\u0011b\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002/\u0002!}kW-\\8ssN#xN]3`I\u0015\fHCA/a!\tid,\u0003\u0002`g\t!QK\\5u\u0011\u001d\t',!AA\u0002M\u000b1\u0001\u001f\u00132\u0011%\u0019\u0007\u00011A\u0001B\u0003&1+A\u0007`[\u0016lwN]=Ti>\u0014X\r\t\u0005\u0006K\u0002!\tAU\u0001\f[\u0016lwN]=Ti>\u0014X\rC\u0003h\u0001\u0011\u0015\u0001.\u0001\btKRlU-\\8ssN#xN]3\u0015\u0005uK\u0007\"\u00026g\u0001\u0004\u0019\u0016!B:u_J,\u0007\"\u00027\u0001\t\u0003i\u0017!D1dcVL'/Z'f[>\u0014\u0018\u0010F\u0002oc^\u0004\"!P8\n\u0005A\u001c$a\u0002\"p_2,\u0017M\u001c\u0005\u0006e.\u0004\ra]\u0001\bE2|7m[%e!\t!X/D\u0001W\u0013\t1hKA\u0004CY>\u001c7.\u00133\t\u000ba\\\u0007\u0019\u0001\u001f\u0002\u00119,XNQ=uKNDQ\u0001\u001c\u0001\u0005\u0002i$BA\\>}}\")!/\u001fa\u0001g\")Q0\u001fa\u0001y\u0005\tb.^7CsR,7\u000fV8BGF,\u0018N]3\t\u000b}L\b\u0019\u0001\u001f\u0002\u001d9,XNQ=uKN$vN\u0012:fK\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011!\u0004:fY\u0016\f7/Z'f[>\u0014\u0018\u0010F\u0002^\u0003\u000fAq!!\u0003\u0002\u0002\u0001\u0007A(\u0001\u0003tSj,\u0007bBA\u0007\u0001\u0011\u0005\u0011qB\u0001\u0011e\u0016dW-Y:f\u00032dW*Z7pef$\u0012!\u0018\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003U1'/Z3Ta\u0006\u001cW\rV8TQJLgn\u001b)p_2$2\u0001PA\f\u0011\u001d\tI\"!\u0005A\u0002q\n1b\u001d9bG\u0016$vN\u0012:fK\u0002")
public class StorageMemoryPool
extends MemoryPool
implements Logging {
    private final Object lock;
    private final MemoryMode memoryMode;
    private final String poolName;
    @GuardedBy(value="lock")
    private long _memoryUsed;
    private MemoryStore _memoryStore;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public long memoryUsed() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            l = this._memoryUsed;
        }
        return l;
    }

    private MemoryStore _memoryStore() {
        return this._memoryStore;
    }

    private void _memoryStore_$eq(MemoryStore x$1) {
        this._memoryStore = x$1;
    }

    public MemoryStore memoryStore() {
        if (this._memoryStore() == null) {
            throw new IllegalStateException("memory store not initialized yet");
        }
        return this._memoryStore();
    }

    public final void setMemoryStore(MemoryStore store) {
        this._memoryStore_$eq(store);
    }

    public boolean acquireMemory(BlockId blockId, long numBytes) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            long numBytesToFree = package$.MODULE$.max(0L, numBytes - this.memoryFree());
            bl = this.acquireMemory(blockId, numBytes, numBytesToFree);
        }
        return bl;
    }

    public boolean acquireMemory(BlockId blockId, long numBytesToAcquire, long numBytesToFree) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            boolean enoughMemory;
            Predef$.MODULE$.assert(numBytesToAcquire >= 0L);
            Predef$.MODULE$.assert(numBytesToFree >= 0L);
            Predef$.MODULE$.assert(this.memoryUsed() <= this.poolSize());
            Object object2 = numBytesToFree > 0L ? BoxesRunTime.boxToLong((long)this.memoryStore().evictBlocksToFreeSpace((Option<BlockId>)new Some((Object)blockId), numBytesToFree, this.memoryMode)) : BoxedUnit.UNIT;
            boolean bl2 = enoughMemory = numBytesToAcquire <= this.memoryFree();
            if (enoughMemory) {
                this._memoryUsed += numBytesToAcquire;
            }
            bl = enoughMemory;
        }
        return bl;
    }

    public void releaseMemory(long size) {
        Object object = this.lock;
        synchronized (object) {
            if (size > this._memoryUsed) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Attempted to release ").append(size).append(" bytes of storage ").append(new StringBuilder(31).append("memory when we only have ").append($this._memoryUsed).append(" bytes").toString()).toString());
                this._memoryUsed = 0L;
            } else {
                this._memoryUsed -= size;
            }
        }
    }

    public void releaseAllMemory() {
        Object object = this.lock;
        synchronized (object) {
            this._memoryUsed = 0L;
        }
    }

    public long freeSpaceToShrinkPool(long spaceToFree) {
        long l;
        Object object = this.lock;
        synchronized (object) {
            long l2;
            long spaceFreedByReleasingUnusedMemory = package$.MODULE$.min(spaceToFree, this.memoryFree());
            long remainingSpaceToFree = spaceToFree - spaceFreedByReleasingUnusedMemory;
            if (remainingSpaceToFree > 0L) {
                long spaceFreedByEviction = this.memoryStore().evictBlocksToFreeSpace((Option<BlockId>)None$.MODULE$, remainingSpaceToFree, this.memoryMode);
                l2 = spaceFreedByReleasingUnusedMemory + spaceFreedByEviction;
            } else {
                l2 = spaceFreedByReleasingUnusedMemory;
            }
            l = l2;
        }
        return l;
    }

    public StorageMemoryPool(Object lock, MemoryMode memoryMode) {
        String string;
        this.lock = lock;
        this.memoryMode = memoryMode;
        super(lock);
        Logging.$init$(this);
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            string = "on-heap storage";
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            string = "off-heap storage";
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        this.poolName = string;
        this._memoryUsed = 0L;
    }
}

