/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.MemoryPool;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0001\u0003\u0001\tQ!aE#yK\u000e,H/[8o\u001b\u0016lwN]=Q_>d'BA\u0002\u0005\u0003\u0019iW-\\8ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017=\u0001\"\u0001D\u0007\u000e\u0003\tI!A\u0004\u0002\u0003\u00155+Wn\u001c:z!>|G\u000e\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t1|7m[\u0002\u0001!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u00142kK\u000e$\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u00155,Wn\u001c:z\u001b>$W\r\u0005\u0002\rG%\u0011AE\u0001\u0002\u000b\u001b\u0016lwN]=N_\u0012,\u0007\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\bF\u0002)S)\u0002\"\u0001\u0004\u0001\t\u000bY)\u0003\u0019\u0001\r\t\u000b\u0005*\u0003\u0019\u0001\u0012\t\r1\u0002\u0001\u0015!\u0003.\u0003!\u0001xn\u001c7OC6,\u0007C\u0001\u00188\u001d\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u00023/\u00051AH]8pizR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011ag\r\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u00035iW-\\8ss\u001a{'\u000fV1tWV\tQ\b\u0005\u0003?\u0007\u0016+U\"A \u000b\u0005\u0001\u000b\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0005N\n!bY8mY\u0016\u001cG/[8o\u0013\t!uHA\u0004ICNDW*\u00199\u0011\u0005\u0019;U\"A\u001a\n\u0005!\u001b$\u0001\u0002'p]\u001eDaA\u0013\u0001!\u0002\u0013i\u0014AD7f[>\u0014\u0018PR8s)\u0006\u001c8\u000e\t\u0015\u0005\u001323v\u000b\u0005\u0002N)6\taJ\u0003\u0002P!\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005E\u0013\u0016AC1o]>$\u0018\r^5p]*\t1+A\u0003kCZ\f\u00070\u0003\u0002V\u001d\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002-!)\u0011\f\u0001C!5\u0006QQ.Z7pef,6/\u001a3\u0016\u0003\u0015CQ\u0001\u0018\u0001\u0005\u0002u\u000bQcZ3u\u001b\u0016lwN]=Vg\u0006<WMR8s)\u0006\u001c8\u000e\u0006\u0002F=\")ql\u0017a\u0001\u000b\u0006iA/Y:l\u0003R$X-\u001c9u\u0013\u0012Da!\u0019\u0001\u0005\u0002\t\u0011\u0017!D1dcVL'/Z'f[>\u0014\u0018\u0010F\u0003FG\u00164g\u000eC\u0003eA\u0002\u0007Q)\u0001\u0005ok6\u0014\u0015\u0010^3t\u0011\u0015y\u0006\r1\u0001F\u0011\u001d9\u0007\r%AA\u0002!\fQ\"\\1zE\u0016<%o\\<Q_>d\u0007\u0003\u0002$j\u000b.L!A[\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001$m\u0013\ti7G\u0001\u0003V]&$\bbB8a!\u0003\u0005\r\u0001]\u0001\u0013G>l\u0007/\u001e;f\u001b\u0006D\bk\\8m'&TX\rE\u0002Gc\u0016K!A]\u001a\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\"\u0002;\u0001\t\u0003)\u0018!\u0004:fY\u0016\f7/Z'f[>\u0014\u0018\u0010F\u0002lm^DQ\u0001Z:A\u0002\u0015CQaX:A\u0002\u0015CQ!\u001f\u0001\u0005\u0002i\fqC]3mK\u0006\u001cX-\u00117m\u001b\u0016lwN]=G_J$\u0016m]6\u0015\u0005\u0015[\b\"B0y\u0001\u0004)\u0005\u0002C?\u0001#\u0003%\tA\u0001@\u0002/\u0005\u001c\u0017/^5sK6+Wn\u001c:zI\u0011,g-Y;mi\u0012\u001aT#A@+\u0007!\f\ta\u000b\u0002\u0002\u0004A!\u0011QAA\u0007\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\t\t6'\u0003\u0003\u0002\u0010\u0005\u001d!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u00111\u0003\u0001\u0012\u0002\u0013\u0005!!!\u0006\u0002/\u0005\u001c\u0017/^5sK6+Wn\u001c:zI\u0011,g-Y;mi\u0012\"TCAA\fU\r\u0001\u0018\u0011\u0001")
public class ExecutionMemoryPool
extends MemoryPool
implements Logging {
    private final Object lock;
    private final String poolName;
    @GuardedBy(value="lock")
    private final HashMap<Object, Object> memoryForTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<Object, Object> memoryForTask() {
        return this.memoryForTask;
    }

    @Override
    public long memoryUsed() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            l = BoxesRunTime.unboxToLong((Object)this.memoryForTask().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        return l;
    }

    public long getMemoryUsageForTask(long taskAttemptId) {
        long l;
        Object object = this.lock;
        synchronized (object) {
            l = BoxesRunTime.unboxToLong((Object)this.memoryForTask().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }
        return l;
    }

    public long acquireMemory(long numBytes, long taskAttemptId, Function1<Object, BoxedUnit> maybeGrowPool, Function0<Object> computeMaxPoolSize) {
        Object object = this.lock;
        synchronized (object) {
            long toGrant;
            Predef$.MODULE$.assert(numBytes > 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("invalid number of bytes requested: ").append(numBytes).toString());
            if (!this.memoryForTask().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                this.memoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)0L));
                this.lock.notifyAll();
            }
            while (true) {
                int numActiveTasks = this.memoryForTask().keys().size();
                long curMem = BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId)));
                maybeGrowPool.apply$mcVJ$sp(numBytes - this.memoryFree());
                long maxPoolSize = computeMaxPoolSize.apply$mcJ$sp();
                long maxMemoryPerTask = maxPoolSize / (long)numActiveTasks;
                long minMemoryPerTask = this.poolSize() / (long)(2 * numActiveTasks);
                long maxToGrant = package$.MODULE$.min(numBytes, package$.MODULE$.max(0L, maxMemoryPerTask - curMem));
                toGrant = package$.MODULE$.min(maxToGrant, this.memoryFree());
                if (toGrant >= numBytes || curMem + toGrant >= minMemoryPerTask) break;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("TID ").append(taskAttemptId).append(" waiting for at least 1/2N of ").append($this.poolName).append(" pool to be free").toString());
                this.lock.wait();
            }
            this.memoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) + toGrant)));
            long l = toGrant;
            return l;
        }
    }

    public Function1<Object, BoxedUnit> acquireMemory$default$3() {
        return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)additionalSpaceNeeded -> {};
    }

    public Function0<Object> acquireMemory$default$4() {
        return (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.poolSize();
    }

    public void releaseMemory(long numBytes, long taskAttemptId) {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            long memoryToFree;
            long l;
            long curMem = BoxesRunTime.unboxToLong((Object)this.memoryForTask().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            if (curMem < numBytes) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Internal error: release called on ").append(numBytes).append(" bytes but task only has ").append(curMem).append(" bytes ").append(new StringBuilder(24).append("of memory from the ").append($this.poolName).append(" pool").toString()).toString());
                l = curMem;
            } else {
                l = memoryToFree = numBytes;
            }
            if (this.memoryForTask().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                this.memoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToFree)));
                object2 = BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) <= 0L ? this.memoryForTask().remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            this.lock.notifyAll();
        }
    }

    public long releaseAllMemoryForTask(long taskAttemptId) {
        long l;
        Object object = this.lock;
        synchronized (object) {
            long numBytesToFree = this.getMemoryUsageForTask(taskAttemptId);
            this.releaseMemory(numBytesToFree, taskAttemptId);
            l = numBytesToFree;
        }
        return l;
    }

    public ExecutionMemoryPool(Object lock, MemoryMode memoryMode) {
        String string;
        this.lock = lock;
        super(lock);
        Logging.$init$(this);
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            string = "on-heap execution";
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            string = "off-heap execution";
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        this.poolName = string;
        this.memoryForTask = new HashMap();
    }
}

