/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.ExecutorState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.FileAppender$;
import org.slf4j.Logger;
import org.spark_project.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b!B\u0001\u0003\u0001\u0011a!AD#yK\u000e,Ho\u001c:Sk:tWM\u001d\u0006\u0003\u0007\u0011\taa^8sW\u0016\u0014(BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0006CB\u0004\u0018\nZ\u0002\u0001+\u0005i\u0002C\u0001\u0010&\u001d\ty2\u0005\u0005\u0002!\u001f5\t\u0011E\u0003\u0002#7\u00051AH]8pizJ!\u0001J\b\u0002\rA\u0013X\rZ3g\u0013\t1sE\u0001\u0004TiJLgn\u001a\u0006\u0003I=A\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0007CB\u0004\u0018\n\u001a\u0011\t\u0011-\u0002!Q1A\u0005\u00021\na!\u001a=fG&#W#A\u0017\u0011\u00059q\u0013BA\u0018\u0010\u0005\rIe\u000e\u001e\u0005\tc\u0001\u0011\t\u0011)A\u0005[\u00059Q\r_3d\u0013\u0012\u0004\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\u0002\u000f\u0005\u0004\b\u000fR3tGV\tQ\u0007\u0005\u00027o5\tA!\u0003\u00029\t\t1\u0012\t\u001d9mS\u000e\fG/[8o\t\u0016\u001c8M]5qi&|g\u000e\u0003\u0005;\u0001\t\u0005\t\u0015!\u00036\u0003!\t\u0007\u000f\u001d#fg\u000e\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002\u000b\r|'/Z:\t\u0011y\u0002!\u0011!Q\u0001\n5\naaY8sKN\u0004\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002\r5,Wn\u001c:z\u0011!\u0011\u0005A!A!\u0002\u0013i\u0013aB7f[>\u0014\u0018\u0010\t\u0005\t\u0007\u0001\u0011)\u0019!C\u0001\tV\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002I\r\u0005\u0019!\u000f]2\n\u0005);%A\u0004*qG\u0016sG\r]8j]R\u0014VM\u001a\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u000b\u00069qo\u001c:lKJ\u0004\u0003\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u0011]|'o[3s\u0013\u0012D\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!H\u0001\no>\u00148.\u001a:JI\u0002B\u0001B\u0015\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0005Q>\u001cH\u000f\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u0015Awn\u001d;!\u0011!1\u0006A!b\u0001\n\u0003a\u0013!C<fEVK\u0007k\u001c:u\u0011!A\u0006A!A!\u0002\u0013i\u0013AC<fEVK\u0007k\u001c:uA!A!\f\u0001BC\u0002\u0013\u0005A$A\u0007qk\nd\u0017nY!eIJ,7o\u001d\u0005\t9\u0002\u0011\t\u0011)A\u0005;\u0005q\u0001/\u001e2mS\u000e\fE\r\u001a:fgN\u0004\u0003\u0002\u00030\u0001\u0005\u000b\u0007I\u0011A0\u0002\u0013M\u0004\u0018M]6I_6,W#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017AA5p\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\t\u0019KG.\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005A\u0006Q1\u000f]1sW\"{W.\u001a\u0011\t\u0011-\u0004!Q1A\u0005\u0002}\u000b1\"\u001a=fGV$xN\u001d#je\"AQ\u000e\u0001B\u0001B\u0003%\u0001-\u0001\u0007fq\u0016\u001cW\u000f^8s\t&\u0014\b\u0005\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003%9xN]6feV\u0013H\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003\u001e\u0003)9xN]6feV\u0013H\u000e\t\u0005\tg\u0002\u0011\t\u0011)A\u0005i\u0006!1m\u001c8g!\t)h/D\u0001\u0007\u0013\t9hAA\u0005Ta\u0006\u00148nQ8oM\"A\u0011\u0010\u0001BC\u0002\u0013\u0005!0\u0001\u0007baBdunY1m\t&\u00148/F\u0001|!\u0011a\u00181A\u000f\u000f\u0005u|hB\u0001\u0011\u007f\u0013\u0005\u0001\u0012bAA\u0001\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0003\u0003\u000f\u00111aU3r\u0015\r\t\ta\u0004\u0005\n\u0003\u0017\u0001!\u0011!Q\u0001\nm\fQ\"\u00199q\u0019>\u001c\u0017\r\u001c#jeN\u0004\u0003BCA\b\u0001\t\u0005\r\u0011\"\u0001\u0002\u0012\u0005)1\u000f^1uKV\u0011\u00111\u0003\t\u0005\u0003+\tYBD\u00027\u0003/I1!!\u0007\u0005\u00035)\u00050Z2vi>\u00148\u000b^1uK&!\u0011QDA\u0010\u0005\u00151\u0016\r\\;f\u0013\r\t\tc\u0004\u0002\f\u000b:,X.\u001a:bi&|g\u000e\u0003\u0006\u0002&\u0001\u0011\t\u0019!C\u0001\u0003O\t\u0011b\u001d;bi\u0016|F%Z9\u0015\t\u0005%\u0012q\u0006\t\u0004\u001d\u0005-\u0012bAA\u0017\u001f\t!QK\\5u\u0011)\t\t$a\t\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0004BCA\u001b\u0001\t\u0005\t\u0015)\u0003\u0002\u0014\u000511\u000f^1uK\u0002BC!a\r\u0002:A\u0019a\"a\u000f\n\u0007\u0005urB\u0001\u0005w_2\fG/\u001b7f\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007\na\u0001P5oSRtDCIA#\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\n9\u0007E\u0002\u0002H\u0001i\u0011A\u0001\u0005\u00075\u0005}\u0002\u0019A\u000f\t\r-\ny\u00041\u0001.\u0011\u0019\u0019\u0014q\ba\u0001k!1A(a\u0010A\u00025Ba\u0001QA \u0001\u0004i\u0003BB\u0002\u0002@\u0001\u0007Q\t\u0003\u0004O\u0003\u007f\u0001\r!\b\u0005\u0007%\u0006}\u0002\u0019A\u000f\t\rY\u000by\u00041\u0001.\u0011\u0019Q\u0016q\ba\u0001;!1a,a\u0010A\u0002\u0001Daa[A \u0001\u0004\u0001\u0007BB8\u0002@\u0001\u0007Q\u0004\u0003\u0004t\u0003\u007f\u0001\r\u0001\u001e\u0005\u0007s\u0006}\u0002\u0019A>\t\u0011\u0005=\u0011q\ba\u0001\u0003'A\u0011\"a\u001b\u0001\u0005\u0004%I!!\u001c\u0002\r\u0019,H\u000e\\%e+\t\ty\u0007\u0005\u0003\u0002r\u0005]TBAA:\u0015\r\t)\bZ\u0001\u0005Y\u0006tw-C\u0002'\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011qN\u0001\bMVdG.\u00133!\u0011%\ty\b\u0001a\u0001\n\u0013\t\t)\u0001\u0007x_J\\WM\u001d+ie\u0016\fG-\u0006\u0002\u0002\u0004B!\u0011\u0011OAC\u0013\u0011\t9)a\u001d\u0003\rQC'/Z1e\u0011%\tY\t\u0001a\u0001\n\u0013\ti)\u0001\tx_J\\WM\u001d+ie\u0016\fGm\u0018\u0013fcR!\u0011\u0011FAH\u0011)\t\t$!#\u0002\u0002\u0003\u0007\u00111\u0011\u0005\t\u0003'\u0003\u0001\u0015)\u0003\u0002\u0004\u0006iqo\u001c:lKJ$\u0006N]3bI\u0002B\u0011\"a&\u0001\u0001\u0004%I!!'\u0002\u000fA\u0014xnY3tgV\u0011\u00111\u0014\t\u0005\u0003c\ni*\u0003\u0003\u0002 \u0006M$a\u0002)s_\u000e,7o\u001d\u0005\n\u0003G\u0003\u0001\u0019!C\u0005\u0003K\u000b1\u0002\u001d:pG\u0016\u001c8o\u0018\u0013fcR!\u0011\u0011FAT\u0011)\t\t$!)\u0002\u0002\u0003\u0007\u00111\u0014\u0005\t\u0003W\u0003\u0001\u0015)\u0003\u0002\u001c\u0006A\u0001O]8dKN\u001c\b\u0005C\u0005\u00020\u0002\u0001\r\u0011\"\u0003\u00022\u0006q1\u000f\u001e3pkR\f\u0005\u000f]3oI\u0016\u0014XCAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bq\u0001\\8hO&twMC\u0002\u0002>\u001a\tA!\u001e;jY&!\u0011\u0011YA\\\u000511\u0015\u000e\\3BaB,g\u000eZ3s\u0011%\t)\r\u0001a\u0001\n\u0013\t9-\u0001\nti\u0012|W\u000f^!qa\u0016tG-\u001a:`I\u0015\fH\u0003BA\u0015\u0003\u0013D!\"!\r\u0002D\u0006\u0005\t\u0019AAZ\u0011!\ti\r\u0001Q!\n\u0005M\u0016aD:uI>,H/\u00119qK:$WM\u001d\u0011\t\u0013\u0005E\u0007\u00011A\u0005\n\u0005E\u0016AD:uI\u0016\u0014(/\u00119qK:$WM\u001d\u0005\n\u0003+\u0004\u0001\u0019!C\u0005\u0003/\f!c\u001d;eKJ\u0014\u0018\t\u001d9f]\u0012,'o\u0018\u0013fcR!\u0011\u0011FAm\u0011)\t\t$a5\u0002\u0002\u0003\u0007\u00111\u0017\u0005\t\u0003;\u0004\u0001\u0015)\u0003\u00024\u0006y1\u000f\u001e3feJ\f\u0005\u000f]3oI\u0016\u0014\b\u0005\u0003\u0005\u0002b\u0002\u0011\r\u0011\"\u0003-\u0003u)\u0005,R\"V)>\u0013v\fV#S\u001b&s\u0015\tV#`)&kUiT+U?6\u001b\u0006bBAs\u0001\u0001\u0006I!L\u0001\u001f\u000bb+5)\u0016+P%~#VIU'J\u001d\u0006#Vi\u0018+J\u001b\u0016{U\u000bV0N'\u0002B\u0011\"!;\u0001\u0001\u0004%I!a;\u0002\u0019MDW\u000f\u001e3po:Dun\\6\u0016\u00035A\u0011\"a<\u0001\u0001\u0004%I!!=\u0002!MDW\u000f\u001e3po:Dun\\6`I\u0015\fH\u0003BA\u0015\u0003gD\u0011\"!\r\u0002n\u0006\u0005\t\u0019A\u0007\t\u000f\u0005]\b\u0001)Q\u0005\u001b\u0005i1\u000f[;uI><h\u000eS8pW\u0002B\u0001\"a?\u0001\t\u0003\u0011\u0011Q`\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003SAqA!\u0001\u0001\t\u0013\u0011\u0019!A\u0006lS2d\u0007K]8dKN\u001cH\u0003BA\u0015\u0005\u000bA\u0001Ba\u0002\u0002\u0000\u0002\u0007!\u0011B\u0001\b[\u0016\u001c8/Y4f!\u0011q!1B\u000f\n\u0007\t5qB\u0001\u0004PaRLwN\u001c\u0005\t\u0005#\u0001A\u0011\u0001\u0002\u0002~\u0006!1.\u001b7m\u0011!\u0011)\u0002\u0001C\u0001\u0005\t]\u0011aE:vEN$\u0018\u000e^;uKZ\u000b'/[1cY\u0016\u001cHcA\u000f\u0003\u001a!9!1\u0004B\n\u0001\u0004i\u0012\u0001C1sOVlWM\u001c;\t\u000f\t}\u0001\u0001\"\u0003\u0002~\u0006\u0019b-\u001a;dQ\u0006sGMU;o\u000bb,7-\u001e;pe\u0002")
public class ExecutorRunner
implements Logging {
    private final String appId;
    private final int execId;
    private final ApplicationDescription appDesc;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef worker;
    private final String workerId;
    private final String host;
    private final int webUiPort;
    private final String publicAddress;
    private final File sparkHome;
    private final File executorDir;
    private final String workerUrl;
    private final SparkConf conf;
    private final Seq<String> appLocalDirs;
    private volatile Enumeration.Value state;
    private final String org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    private Thread workerThread;
    private Process process;
    private FileAppender stdoutAppender;
    private FileAppender stderrAppender;
    private final int EXECUTOR_TERMINATE_TIMEOUT_MS;
    private Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public int execId() {
        return this.execId;
    }

    public ApplicationDescription appDesc() {
        return this.appDesc;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerId() {
        return this.workerId;
    }

    public String host() {
        return this.host;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public String publicAddress() {
        return this.publicAddress;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public File executorDir() {
        return this.executorDir;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public Seq<String> appLocalDirs() {
        return this.appLocalDirs;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public String org$apache$spark$deploy$worker$ExecutorRunner$$fullId() {
        return this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private FileAppender stdoutAppender() {
        return this.stdoutAppender;
    }

    private void stdoutAppender_$eq(FileAppender x$1) {
        this.stdoutAppender = x$1;
    }

    private FileAppender stderrAppender() {
        return this.stderrAppender;
    }

    private void stderrAppender_$eq(FileAppender x$1) {
        this.stderrAppender = x$1;
    }

    private int EXECUTOR_TERMINATE_TIMEOUT_MS() {
        return this.EXECUTOR_TERMINATE_TIMEOUT_MS;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    private void shutdownHook_$eq(Object x$1) {
        this.shutdownHook = x$1;
    }

    public void start() {
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ ExecutorRunner $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(19).append("ExecutorRunner for ").append($outer.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).toString());
            }
        });
        this.workerThread().start();
        this.shutdownHook_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Enumeration.Value value = this.state();
            Enumeration.Value value2 = ExecutorState$.MODULE$.RUNNING();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.state_$eq(ExecutorState$.MODULE$.FAILED());
            }
            this.killProcess((Option<String>)new Some((Object)"Worker shutting down"));
        }));
    }

    private void killProcess(Option<String> message) {
        Option<Object> exitCode = None$.MODULE$;
        if (this.process() != null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing process!");
            if (this.stdoutAppender() != null) {
                this.stdoutAppender().stop();
            }
            if (this.stderrAppender() != null) {
                this.stderrAppender().stop();
            }
            if ((exitCode = Utils$.MODULE$.terminateProcess(this.process(), this.EXECUTOR_TERMINATE_TIMEOUT_MS())).isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Failed to terminate process: ").append(this.process()).append(". This process will likely be orphaned.").toString());
            }
        }
        try {
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), message, exitCode));
        }
        catch (IllegalStateException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
        }
    }

    public void kill() {
        block2: {
            if (this.workerThread() == null) break block2;
            this.workerThread().interrupt();
            this.workerThread_$eq(null);
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            try {
                ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook());
            }
            catch (IllegalStateException e) {
            }
        }
    }

    public String substituteVariables(String argument) {
        String string = argument;
        String string2 = "{{WORKER_URL}}".equals(string) ? this.workerUrl() : ("{{EXECUTOR_ID}}".equals(string) ? ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString() : ("{{HOSTNAME}}".equals(string) ? this.host() : ("{{CORES}}".equals(string) ? ((Object)BoxesRunTime.boxToInteger((int)this.cores())).toString() : ("{{APP_ID}}".equals(string) ? this.appId() : string))));
        return string2;
    }

    public void org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor() {
        try {
            Seq subsOpts;
            Seq x$2 = subsOpts = (Seq)this.appDesc().command().javaOpts().map((Function1 & Serializable & scala.Serializable)x$1 -> Utils$.MODULE$.substituteAppNExecIds((String)x$1, this.appId(), ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString()), Seq$.MODULE$.canBuildFrom());
            String x$3 = this.appDesc().command().copy$default$1();
            Seq<String> x$4 = this.appDesc().command().copy$default$2();
            Map<String, String> x$5 = this.appDesc().command().copy$default$3();
            Seq<String> x$6 = this.appDesc().command().copy$default$4();
            Seq<String> x$7 = this.appDesc().command().copy$default$5();
            Command subsCommand = this.appDesc().command().copy(x$3, x$4, x$5, x$6, x$7, (Seq<String>)x$2);
            ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(subsCommand, new SecurityManager(this.conf, SecurityManager$.MODULE$.$lessinit$greater$default$2()), this.memory(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables((String)argument), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
            List<String> command = builder.command();
            String formattedCommand = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala()).mkString("\"", "\" \"", "\"");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch command: ").append(formattedCommand).toString());
            builder.directory(this.executorDir());
            builder.environment().put("SPARK_EXECUTOR_DIRS", this.appLocalDirs().mkString(File.pathSeparator));
            builder.environment().put("SPARK_LAUNCH_WITH_SCALA", "0");
            String baseUrl = this.conf.getBoolean("spark.ui.reverseProxy", false) ? new StringBuilder(44).append("/proxy/").append(this.workerId()).append("/logPage/?appId=").append(this.appId()).append("&executorId=").append(this.execId()).append("&logType=").toString() : new StringBuilder(45).append("http://").append(this.publicAddress()).append(":").append(this.webUiPort()).append("/logPage/?appId=").append(this.appId()).append("&executorId=").append(this.execId()).append("&logType=").toString();
            builder.environment().put("SPARK_LOG_URL_STDERR", new StringBuilder(6).append(baseUrl).append("stderr").toString());
            builder.environment().put("SPARK_LOG_URL_STDOUT", new StringBuilder(6).append(baseUrl).append("stdout").toString());
            this.process_$eq(builder.start());
            String header = new StringOps(Predef$.MODULE$.augmentString("Spark Executor Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
            File stdout = new File(this.executorDir(), "stdout");
            this.stdoutAppender_$eq(FileAppender$.MODULE$.apply(this.process().getInputStream(), stdout, this.conf));
            File stderr = new File(this.executorDir(), "stderr");
            Files.write((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
            this.stderrAppender_$eq(FileAppender$.MODULE$.apply(this.process().getErrorStream(), stderr, this.conf));
            int exitCode = this.process().waitFor();
            this.state_$eq(ExecutorState$.MODULE$.EXITED());
            String message = new StringBuilder(25).append("Command exited with code ").append(exitCode).toString();
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), (Option<String>)new Some((Object)message), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)exitCode))));
        }
        catch (InterruptedException interrupted) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Runner thread for executor ").append(this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).append(" interrupted").toString());
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            this.killProcess((Option<String>)None$.MODULE$);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error running executor", e);
            this.state_$eq(ExecutorState$.MODULE$.FAILED());
            this.killProcess((Option<String>)new Some((Object)e.toString()));
        }
    }

    public ExecutorRunner(String appId, int execId, ApplicationDescription appDesc, int cores, int memory, RpcEndpointRef worker, String workerId, String host, int webUiPort, String publicAddress, File sparkHome, File executorDir, String workerUrl, SparkConf conf, Seq<String> appLocalDirs, Enumeration.Value state) {
        this.appId = appId;
        this.execId = execId;
        this.appDesc = appDesc;
        this.cores = cores;
        this.memory = memory;
        this.worker = worker;
        this.workerId = workerId;
        this.host = host;
        this.webUiPort = webUiPort;
        this.publicAddress = publicAddress;
        this.sparkHome = sparkHome;
        this.executorDir = executorDir;
        this.workerUrl = workerUrl;
        this.conf = conf;
        this.appLocalDirs = appLocalDirs;
        this.state = state;
        Logging.$init$(this);
        this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId = new StringBuilder(1).append(appId).append("/").append(execId).toString();
        this.workerThread = null;
        this.process = null;
        this.stdoutAppender = null;
        this.stderrAppender = null;
        this.EXECUTOR_TERMINATE_TIMEOUT_MS = 10000;
        this.shutdownHook = null;
    }
}

