/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.KillSubmissionResponse;
import org.apache.spark.deploy.rest.RestSubmissionClient$;
import org.apache.spark.deploy.rest.RestSubmissionServer$;
import org.apache.spark.deploy.rest.SubmissionStatusResponse;
import org.apache.spark.deploy.rest.SubmitRestConnectionException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException$;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage$;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0001\u0019a!\u0001\u0006*fgR\u001cVOY7jgNLwN\\\"mS\u0016tGO\u0003\u0002\u0004\t\u0005!!/Z:u\u0015\t)a!\u0001\u0004eKBdw.\u001f\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!\u0011!Q\u0001\nq\ta!\\1ti\u0016\u00148\u0001\u0001\t\u0003;\u0011r!A\b\u0012\u0011\u0005}yQ\"\u0001\u0011\u000b\u0005\u0005Z\u0012A\u0002\u001fs_>$h(\u0003\u0002$\u001f\u00051\u0001K]3eK\u001aL!!\n\u0014\u0003\rM#(/\u001b8h\u0015\t\u0019s\u0002C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u0003\tAQAG\u0014A\u0002qAqA\f\u0001C\u0002\u0013%q&A\ftkB\u0004xN\u001d;fI6\u000b7\u000f^3s!J,g-\u001b=fgV\t\u0001\u0007E\u00022iYj\u0011A\r\u0006\u0003g=\t!bY8mY\u0016\u001cG/[8o\u0013\t)$GA\u0002TKF\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t1\fgn\u001a\u0006\u0002w\u0005!!.\u0019<b\u0013\t)\u0003\b\u0003\u0004?\u0001\u0001\u0006I\u0001M\u0001\u0019gV\u0004\bo\u001c:uK\u0012l\u0015m\u001d;feB\u0013XMZ5yKN\u0004\u0003b\u0002!\u0001\u0005\u0004%I!Q\u0001\b[\u0006\u001cH/\u001a:t+\u0005\u0011\u0005c\u0001\bD9%\u0011Ai\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\"\u0002\u00115\f7\u000f^3sg\u0002Bq\u0001\u0013\u0001C\u0002\u0013%\u0011*A\u0006m_N$X*Y:uKJ\u001cX#\u0001&\u0011\u0007-sE$D\u0001M\u0015\ti%'A\u0004nkR\f'\r\\3\n\u0005=c%a\u0002%bg\"\u001cV\r\u001e\u0005\u0007#\u0002\u0001\u000b\u0011\u0002&\u0002\u00191|7\u000f^'bgR,'o\u001d\u0011\t\u000bM\u0003A\u0011\u0001+\u0002!\r\u0014X-\u0019;f'V\u0014W.[:tS>tGCA+Y!\tYc+\u0003\u0002X\u0005\tQ2+\u001e2nSR\u0014Vm\u001d;Qe>$xnY8m%\u0016\u001c\bo\u001c8tK\")\u0011L\u0015a\u00015\u00069!/Z9vKN$\bCA\u0016\\\u0013\ta&AA\fDe\u0016\fG/Z*vE6L7o]5p]J+\u0017/^3ti\")a\f\u0001C\u0001?\u0006q1.\u001b7m'V\u0014W.[:tS>tGCA+a\u0011\u0015\tW\f1\u0001\u001d\u00031\u0019XOY7jgNLwN\\%e\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003]\u0011X-];fgR\u001cVOY7jgNLwN\\*uCR,8\u000fF\u0002VK\u001aDQ!\u00192A\u0002qAqa\u001a2\u0011\u0002\u0003\u0007\u0001.A\u0003rk&,G\u000f\u0005\u0002\u000fS&\u0011!n\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015a\u0007\u0001\"\u0001n\u0003Y\u0019wN\\:ueV\u001cGoU;c[&$(+Z9vKN$HC\u0002.oaJ$\u0018\u0010C\u0003pW\u0002\u0007A$A\u0006baB\u0014Vm]8ve\u000e,\u0007\"B9l\u0001\u0004a\u0012!C7bS:\u001cE.Y:t\u0011\u0015\u00198\u000e1\u0001C\u0003\u001d\t\u0007\u000f]!sONDQ!^6A\u0002Y\fqb\u001d9be.\u0004&o\u001c9feRLWm\u001d\t\u0005;]dB$\u0003\u0002yM\t\u0019Q*\u00199\t\u000bi\\\u0007\u0019\u0001<\u0002)\u0015tg/\u001b:p]6,g\u000e\u001e,be&\f'\r\\3t\u0011\u0015a\b\u0001\"\u0003~\u0003\r9W\r\u001e\u000b\u0003+zDaa`>A\u0002\u0005\u0005\u0011aA;sYB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bi\n1A\\3u\u0013\u0011\tY!!\u0002\u0003\u0007U\u0013F\nC\u0004\u0002\u0010\u0001!I!!\u0005\u0002\tA|7\u000f\u001e\u000b\u0004+\u0006M\u0001bB@\u0002\u000e\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003/\u0001A\u0011BA\r\u0003!\u0001xn\u001d;Kg>tG#B+\u0002\u001c\u0005u\u0001bB@\u0002\u0016\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003?\t)\u00021\u0001\u001d\u0003\u0011Q7o\u001c8\t\u0011\u0005\r\u0002\u0001\"\u0001\u0003\u0003K\tAB]3bIJ+7\u000f]8og\u0016$2!VA\u0014\u0011!\tI#!\tA\u0002\u0005-\u0012AC2p]:,7\r^5p]B!\u00111AA\u0017\u0013\u0011\ty#!\u0002\u0003#!#H\u000f]+S\u0019\u000e{gN\\3di&|g\u000eC\u0004\u00024\u0001!I!!\u000e\u0002\u0019\u001d,GoU;c[&$XK\u001d7\u0015\t\u0005\u0005\u0011q\u0007\u0005\u00075\u0005E\u0002\u0019\u0001\u000f\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\u0005Qq-\u001a;LS2dWK\u001d7\u0015\r\u0005\u0005\u0011qHA!\u0011\u0019Q\u0012\u0011\ba\u00019!1\u0011-!\u000fA\u0002qAq!!\u0012\u0001\t\u0013\t9%\u0001\u0007hKR\u001cF/\u0019;vgV\u0013H\u000e\u0006\u0004\u0002\u0002\u0005%\u00131\n\u0005\u00075\u0005\r\u0003\u0019\u0001\u000f\t\r\u0005\f\u0019\u00051\u0001\u001d\u0011\u001d\ty\u0005\u0001C\u0005\u0003#\n!bZ3u\u0005\u0006\u001cX-\u0016:m)\ra\u00121\u000b\u0005\u00075\u00055\u0003\u0019\u0001\u000f\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005qa/\u00197jI\u0006$X-T1ti\u0016\u0014H\u0003BA.\u0003C\u00022ADA/\u0013\r\tyf\u0004\u0002\u0005+:LG\u000f\u0003\u0004\u001b\u0003+\u0002\r\u0001\b\u0005\b\u0003K\u0002A\u0011BA4\u0003Y\u0011X\r]8siN+(-\\5tg&|gn\u0015;biV\u001cH\u0003BA.\u0003SB\u0001\"a\u001b\u0002d\u0001\u0007\u0011QN\u0001\u000fgV\u0014W.\u001b;SKN\u0004xN\\:f!\rY\u0013qN\u0005\u0004\u0003c\u0012!\u0001G\"sK\u0006$XmU;c[&\u001c8/[8o%\u0016\u001c\bo\u001c8tK\"9\u0011Q\u000f\u0001\u0005\n\u0005]\u0014\u0001\u00069pY2\u001cVOY7jgNLwN\\*uCR,8\u000f\u0006\u0003\u0002\\\u0005e\u0004BB1\u0002t\u0001\u0007A\u0004C\u0004\u0002~\u0001!I!a \u0002%!\fg\u000e\u001a7f%\u0016\u001cHOU3ta>t7/\u001a\u000b\u0005\u00037\n\t\tC\u0004\u0002\u0004\u0006m\u0004\u0019A+\u0002\u0011I,7\u000f]8og\u0016Dq!a\"\u0001\t\u0013\tI)\u0001\u000fiC:$G.Z+oKb\u0004Xm\u0019;fIJ+7\u000f\u001e*fgB|gn]3\u0015\t\u0005m\u00131\u0012\u0005\b\u0003\u001b\u000b)\t1\u0001V\u0003))h.\u001a=qK\u000e$X\r\u001a\u0005\b\u0003#\u0003A\u0011BAJ\u0003eA\u0017M\u001c3mK\u000e{gN\\3di&|g.\u0012=dKB$\u0018n\u001c8\u0015\u0007!\f)\nC\u0004\u0002\u0018\u0006=\u0005\u0019\u0001\u000f\u0002\u00135\f7\u000f^3s+Jd\u0007\"CAN\u0001E\u0005I\u0011AAO\u0003\u0005\u0012X-];fgR\u001cVOY7jgNLwN\\*uCR,8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyJK\u0002i\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[{\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\t\u0003k\u0013\u0001\u0012\u0001\u0004\u00028\u0006!\"+Z:u'V\u0014W.[:tS>t7\t\\5f]R\u00042aKA]\r\u001d\t!\u0001#\u0001\u0007\u0003w\u001b2!!/\u000e\u0011\u001dA\u0013\u0011\u0018C\u0001\u0003\u007f#\"!a.\t\u0015\u0005\r\u0017\u0011\u0018b\u0001\n\u0013\t)-A\u000fS\u000bB{%\u000bV0E%&3VIU0T)\u0006#VkU0J\u001dR+%KV!M+\t\t9\rE\u0002\u000f\u0003\u0013L1!a3\u0010\u0005\rIe\u000e\u001e\u0005\n\u0003\u001f\fI\f)A\u0005\u0003\u000f\faDU#Q\u001fJ#v\f\u0012*J-\u0016\u0013vl\u0015+B)V\u001bv,\u0013(U\u000bJ3\u0016\t\u0014\u0011\t\u0015\u0005M\u0017\u0011\u0018b\u0001\n\u0013\t)-\u0001\u0010S\u000bB{%\u000bV0E%&3VIU0T)\u0006#VkU0N\u0003b{FKU%F'\"I\u0011q[A]A\u0003%\u0011qY\u0001 %\u0016\u0003vJ\u0015+`\tJKe+\u0012*`'R\u000bE+V*`\u001b\u0006Cv\f\u0016*J\u000bN\u0003\u0003BCAn\u0003s\u0013\r\u0011\"\u0001\u0002^\u0006\u0001\u0002KU(U\u001f\u000e{Ej\u0018,F%NKuJT\u000b\u0002m!A\u0011\u0011]A]A\u0003%a'A\tQ%>#vjQ(M?Z+%kU%P\u001d\u0002B\u0011\"!:\u0002:\u0012\u0005!!a:\u0002/\u0019LG\u000e^3s'f\u001cH/Z7F]ZL'o\u001c8nK:$Hc\u0001<\u0002j\"9\u00111^Ar\u0001\u00041\u0018aA3om\u0002")
public class RestSubmissionClient
implements Logging {
    private final String master;
    private final Seq<String> supportedMasterPrefixes;
    private final String[] masters;
    private final HashSet<String> lostMasters;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String PROTOCOL_VERSION() {
        return RestSubmissionClient$.MODULE$.PROTOCOL_VERSION();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<String> supportedMasterPrefixes() {
        return this.supportedMasterPrefixes;
    }

    private String[] masters() {
        return this.masters;
    }

    private HashSet<String> lostMasters() {
        return this.lostMasters;
    }

    public SubmitRestProtocolResponse createSubmission(CreateSubmissionRequest request) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Submitting a request to launch an application in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.masters())).withFilter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$createSubmission$2(handled, m))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            RestSubmissionClient.$anonfun$createSubmission$3(this, request, handled, response, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse killSubmission(String submissionId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Submitting a request to kill submission ").append(submissionId).append(" in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.masters())).withFilter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$killSubmission$2(handled, m))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            RestSubmissionClient.$anonfun$killSubmission$3(this, submissionId, handled, response, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse requestSubmissionStatus(String submissionId, boolean quiet) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Submitting a request for the status of submission ").append(submissionId).append(" in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.masters())).withFilter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$requestSubmissionStatus$2(handled, m))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            RestSubmissionClient.$anonfun$requestSubmissionStatus$3(this, submissionId, quiet, handled, response, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public boolean requestSubmissionStatus$default$2() {
        return false;
    }

    public CreateSubmissionRequest constructSubmitRequest(String appResource, String mainClass, String[] appArgs, Map<String, String> sparkProperties, Map<String, String> environmentVariables) {
        CreateSubmissionRequest message = new CreateSubmissionRequest();
        message.clientSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
        message.appResource_$eq(appResource);
        message.mainClass_$eq(mainClass);
        message.appArgs_$eq(appArgs);
        message.sparkProperties_$eq(sparkProperties);
        message.environmentVariables_$eq(environmentVariables);
        message.validate();
        return message;
    }

    private SubmitRestProtocolResponse get(URL url) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sending GET request to server at ").append(url).append(".").toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        return this.readResponse(conn);
    }

    private SubmitRestProtocolResponse post(URL url) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sending POST request to server at ").append(url).append(".").toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        return this.readResponse(conn);
    }

    private SubmitRestProtocolResponse postJson(URL url, String json) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Sending POST request to server at ").append(url).append(":\n").append(json).toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        try {
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.write(json.getBytes(StandardCharsets.UTF_8)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
        }
        catch (ConnectException e) {
            throw new SubmitRestConnectionException("Connect Exception when connect to server", e);
        }
        return this.readResponse(conn);
    }

    public SubmitRestProtocolResponse readResponse(HttpURLConnection connection) {
        SubmitRestProtocolResponse submitRestProtocolResponse;
        Future responseFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ErrorResponse errorResponse;
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Some errString = new Some((Object)Source$.MODULE$.fromInputStream(connection.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n"));
                if (responseCode == 500 && !connection.getContentType().contains("application/json")) {
                    throw new SubmitRestProtocolException(new StringBuilder(33).append("Server responded with exception:\n").append(errString).toString(), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Server responded with error:\n").append(errString).toString());
                ErrorResponse error = new ErrorResponse();
                if (responseCode == RestSubmissionServer$.MODULE$.SC_UNKNOWN_PROTOCOL_VERSION()) {
                    error.highestProtocolVersion_$eq(RestSubmissionServer$.MODULE$.PROTOCOL_VERSION());
                }
                error.message_$eq((String)errString.get());
                errorResponse = error;
            } else {
                SubmitRestProtocolResponse submitRestProtocolResponse;
                InputStream dataStream = connection.getInputStream();
                if (dataStream == null) {
                    throw new SubmitRestProtocolException("Server returned empty body", SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                String responseJson = Source$.MODULE$.fromInputStream(dataStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Response from the server:\n").append(responseJson).toString());
                SubmitRestProtocolMessage response = SubmitRestProtocolMessage$.MODULE$.fromJson(responseJson);
                response.validate();
                SubmitRestProtocolMessage submitRestProtocolMessage = response;
                if (submitRestProtocolMessage instanceof ErrorResponse) {
                    ErrorResponse errorResponse2 = (ErrorResponse)submitRestProtocolMessage;
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Server responded with error:\n").append(errorResponse2.message()).toString());
                    submitRestProtocolResponse = errorResponse2;
                } else if (submitRestProtocolMessage instanceof SubmitRestProtocolResponse) {
                    SubmitRestProtocolResponse submitRestProtocolResponse2 = (SubmitRestProtocolResponse)submitRestProtocolMessage;
                    submitRestProtocolResponse = submitRestProtocolResponse2;
                } else {
                    throw new SubmitRestProtocolException(new StringBuilder(49).append("Message received from server was not a response:\n").append(submitRestProtocolMessage.toJson()).toString(), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                errorResponse = submitRestProtocolResponse;
            }
            return errorResponse;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            submitRestProtocolResponse = (SubmitRestProtocolResponse)Await$.MODULE$.result((Awaitable)responseFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof SocketException;
            if (bl) {
                throw new SubmitRestConnectionException("Unable to connect to server", throwable2);
            }
            boolean bl2 = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof SubmitRestProtocolException;
            if (bl2) {
                throw new SubmitRestProtocolException("Malformed response received from server", throwable2);
            }
            if (throwable2 instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable2;
                throw new SubmitRestConnectionException("No response from server", timeoutException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new SparkException("Exception while waiting for response", t);
            }
            throw throwable;
        }
        return submitRestProtocolResponse;
    }

    private URL getSubmitUrl(String master) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(7).append(baseUrl).append("/create").toString());
    }

    private URL getKillUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(6).append(baseUrl).append("/kill/").append(submissionId).toString());
    }

    private URL getStatusUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(8).append(baseUrl).append("/status/").append(submissionId).toString());
    }

    private String getBaseUrl(String master) {
        ObjectRef masterUrl = ObjectRef.create((Object)master);
        this.supportedMasterPrefixes().foreach((Function1 & Serializable & scala.Serializable)prefix -> {
            RestSubmissionClient.$anonfun$getBaseUrl$1(master, masterUrl, prefix);
            return BoxedUnit.UNIT;
        });
        masterUrl.elem = new StringOps(Predef$.MODULE$.augmentString((String)masterUrl.elem)).stripSuffix("/");
        return new StringBuilder(20).append("http://").append((String)masterUrl.elem).append("/").append(RestSubmissionClient$.MODULE$.PROTOCOL_VERSION()).append("/submissions").toString();
    }

    private void validateMaster(String master) {
        boolean valid = this.supportedMasterPrefixes().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)master.startsWith(prefix)));
        if (!valid) {
            throw new IllegalArgumentException(new StringBuilder(81).append("This REST client only supports master URLs that start with one of the following: ").append(this.supportedMasterPrefixes().mkString(",")).toString());
        }
    }

    private void reportSubmissionStatus(CreateSubmissionResponse submitResponse) {
        if (Predef$.MODULE$.Boolean2boolean(submitResponse.success())) {
            String submissionId = submitResponse.submissionId();
            if (submissionId != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Submission successfully created as ").append(submissionId).append(". Polling submission state...").toString());
                this.pollSubmissionStatus(submissionId);
            } else {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Application successfully submitted, but submission ID was not provided!");
            }
        } else {
            String failMessage = (String)Option$.MODULE$.apply((Object)submitResponse.message()).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(2).append(": ").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Application submission failed").append(failMessage).toString());
        }
    }

    private void pollSubmissionStatus(String submissionId) {
        Object object = new Object();
        try {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_MAX_TRIES()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> RestSubmissionClient.$anonfun$pollSubmissionStatus$1(this, submissionId, object, arg_0)));
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Error: Master did not recognize driver ").append(submissionId).append(".").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void handleRestResponse(SubmitRestProtocolResponse response) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Server responded with ").append(response.messageType()).append(":\n").append(response.toJson()).toString());
    }

    private void handleUnexpectedRestResponse(SubmitRestProtocolResponse unexpected) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error: Server responded with message of unexpected type ").append(unexpected.messageType()).append(".").toString());
    }

    private boolean handleConnectionException(String masterUrl) {
        BoxedUnit boxedUnit;
        if (!this.lostMasters().contains((Object)masterUrl)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Unable to connect to server ").append(masterUrl).append(".").toString());
            boxedUnit = this.lostMasters().$plus$eq((Object)masterUrl);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.lostMasters().size() >= this.masters().length;
    }

    public static final /* synthetic */ boolean $anonfun$createSubmission$2(BooleanRef handled$1, String m) {
        return !handled$1.elem;
    }

    public static final /* synthetic */ void $anonfun$createSubmission$3(RestSubmissionClient $this, CreateSubmissionRequest request$1, BooleanRef handled$1, ObjectRef response$1, String m) {
        block6: {
            $this.validateMaster(m);
            URL url = $this.getSubmitUrl(m);
            try {
                response$1.elem = $this.postJson(url, request$1.toJson());
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$1.elem;
                if (submitRestProtocolResponse instanceof CreateSubmissionResponse) {
                    BoxedUnit boxedUnit;
                    CreateSubmissionResponse createSubmissionResponse = (CreateSubmissionResponse)submitRestProtocolResponse;
                    if (Predef$.MODULE$.Boolean2boolean(createSubmissionResponse.success())) {
                        $this.reportSubmissionStatus(createSubmissionResponse);
                        $this.handleRestResponse(createSubmissionResponse);
                        handled$1.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block6;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$killSubmission$2(BooleanRef handled$2, String m) {
        return !handled$2.elem;
    }

    public static final /* synthetic */ void $anonfun$killSubmission$3(RestSubmissionClient $this, String submissionId$1, BooleanRef handled$2, ObjectRef response$3, String m) {
        block6: {
            $this.validateMaster(m);
            URL url = $this.getKillUrl(m, submissionId$1);
            try {
                response$3.elem = $this.post(url);
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$3.elem;
                if (submitRestProtocolResponse instanceof KillSubmissionResponse) {
                    BoxedUnit boxedUnit;
                    KillSubmissionResponse killSubmissionResponse = (KillSubmissionResponse)submitRestProtocolResponse;
                    if (!Utils$.MODULE$.responseFromBackup(killSubmissionResponse.message())) {
                        $this.handleRestResponse(killSubmissionResponse);
                        handled$2.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block6;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$requestSubmissionStatus$2(BooleanRef handled$3, String m) {
        return !handled$3.elem;
    }

    public static final /* synthetic */ void $anonfun$requestSubmissionStatus$3(RestSubmissionClient $this, String submissionId$2, boolean quiet$1, BooleanRef handled$3, ObjectRef response$4, String m) {
        block5: {
            $this.validateMaster(m);
            URL url = $this.getStatusUrl(m, submissionId$2);
            try {
                SubmissionStatusResponse submissionStatusResponse;
                response$4.elem = $this.get(url);
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$4.elem;
                if (submitRestProtocolResponse instanceof SubmissionStatusResponse && Predef$.MODULE$.Boolean2boolean((submissionStatusResponse = (SubmissionStatusResponse)submitRestProtocolResponse).success())) {
                    if (!quiet$1) {
                        $this.handleRestResponse(submissionStatusResponse);
                    }
                    handled$3.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block5;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getBaseUrl$1(String master$2, ObjectRef masterUrl$2, String prefix) {
        block0: {
            if (!master$2.startsWith(prefix)) break block0;
            masterUrl$2.elem = new StringOps(Predef$.MODULE$.augmentString(master$2)).stripPrefix(prefix);
        }
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$2(String submissionId$4, String state$1) {
        return new StringBuilder(25).append("State of driver ").append(submissionId$4).append(" is now ").append(state$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$3(String submissionId$4) {
        return new StringBuilder(31).append("State of driver ").append(submissionId$4).append(" was not found!").toString();
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$4(String id$1, String hp$1) {
        return new StringBuilder(33).append("Driver is running on worker ").append(id$1).append(" at ").append(hp$1).append(".").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$pollSubmissionStatus$1(RestSubmissionClient $this, String submissionId$4, Object nonLocalReturnKey1$1, int x$2) {
        block5: {
            response = $this.requestSubmissionStatus(submissionId$4, true);
            var9_5 = response;
            if (!(var9_5 instanceof SubmissionStatusResponse)) {
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            var6_7 = var10_6 = (SubmissionStatusResponse)var9_5;
            statusResponse = var6_7;
            if (!Predef$.MODULE$.Boolean2boolean(statusResponse.success())) break block5;
            driverState = Option$.MODULE$.apply((Object)statusResponse.driverState());
            workerId = Option$.MODULE$.apply((Object)statusResponse.workerId());
            workerHostPort = Option$.MODULE$.apply((Object)statusResponse.workerHostPort());
            exception = Option$.MODULE$.apply((Object)statusResponse.message());
            var15_13 = driverState;
            if (var15_13 instanceof Some) {
                var16_14 = (Some)var15_13;
                state = (String)var16_14.value();
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$2(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)submissionId$4, (String)state));
                var5_16 = BoxedUnit.UNIT;
            } else {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$3(java.lang.String ), ()Ljava/lang/String;)((String)submissionId$4));
                var5_17 = BoxedUnit.UNIT;
            }
            var18_18 = new Tuple2((Object)workerId, (Object)workerHostPort);
            if (var18_18 == null) ** GOTO lbl-1000
            var19_19 = (Option)var18_18._1();
            var20_20 = (Option)var18_18._2();
            if (!(var19_19 instanceof Some)) ** GOTO lbl-1000
            var21_21 = (Some)var19_19;
            id = (String)var21_21.value();
            if (var20_20 instanceof Some) {
                var23_23 = (Some)var20_20;
                hp = (String)var23_23.value();
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$4(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)id, (String)hp));
                var4_25 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 3 sources

            {
                var4_26 = BoxedUnit.UNIT;
            }
            exception.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pollSubmissionStatus$5$adapted(org.apache.spark.deploy.rest.RestSubmissionClient java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((RestSubmissionClient)$this));
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        Thread.sleep(RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_INTERVAL());
    }

    public RestSubmissionClient(String master) {
        this.master = master;
        Logging.$init$(this);
        this.supportedMasterPrefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark://", "mesos://"}));
        this.masters = master.startsWith("spark://") ? Utils$.MODULE$.parseStandaloneMasterUrls(master) : (String[])((Object[])new String[]{master});
        this.lostMasters = new HashSet();
    }

    public static final /* synthetic */ Object $anonfun$pollSubmissionStatus$5$adapted(RestSubmissionClient $this, String e) {
        $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e);
        return BoxedUnit.UNIT;
    }
}

