/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.Serializer;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!B\u0001\u0003\u0001\ta!A\u0007.p_.+W\r]3s!\u0016\u00148/[:uK:\u001cW-\u00128hS:,'BA\u0002\u0005\u0003\u0019i\u0017m\u001d;fe*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0012!\tqq\"D\u0001\u0003\u0013\t\u0001\"AA\tQKJ\u001c\u0018n\u001d;f]\u000e,WI\\4j]\u0016\u0004\"AE\u000b\u000e\u0003MQ!\u0001\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!AF\n\u0003\u000f1{wmZ5oO\"A\u0001\u0004\u0001B\u0001B\u0003%!$\u0001\u0003d_:47\u0001\u0001\t\u00037qi\u0011AB\u0005\u0003;\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011}\u0001!Q1A\u0005\u0002\u0001\n!b]3sS\u0006d\u0017N_3s+\u0005\t\u0003C\u0001\u0012%\u001b\u0005\u0019#BA\u0010\u0007\u0013\t)3E\u0001\u0006TKJL\u0017\r\\5{KJD\u0001b\n\u0001\u0003\u0002\u0003\u0006I!I\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0004W1j\u0003C\u0001\b\u0001\u0011\u0015A\u0002\u00061\u0001\u001b\u0011\u0015y\u0002\u00061\u0001\"\u0011\u001dy\u0003A1A\u0005\nA\n1bV(S\u0017&sui\u0018#J%V\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\rM#(/\u001b8h\u0011\u0019Q\u0004\u0001)A\u0005c\u0005aqk\u0014*L\u0013:;u\fR%SA!9A\b\u0001b\u0001\n\u0013i\u0014A\u0001>l+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u0003%1'/Y7fo>\u00148N\u0003\u0002D\u0011\u000591-\u001e:bi>\u0014\u0018BA#A\u0005A\u0019UO]1u_J4%/Y7fo>\u00148\u000e\u0003\u0004H\u0001\u0001\u0006IAP\u0001\u0004u.\u0004\u0003\"B%\u0001\t\u0003R\u0015a\u00029feNL7\u000f\u001e\u000b\u0004\u0017Fk\u0006C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%\u0001B+oSRDQA\u0015%A\u0002M\u000bAA\\1nKB\u0011Ak\u0017\b\u0003+f\u0003\"AV'\u000e\u0003]S!\u0001W\r\u0002\rq\u0012xn\u001c;?\u0013\tQV*\u0001\u0004Qe\u0016$WMZ\u0005\u0003qqS!AW'\t\u000byC\u0005\u0019A0\u0002\u0007=\u0014'\u000e\u0005\u00023A&\u0011\u0011m\r\u0002\u0007\u001f\nTWm\u0019;\t\u000b\r\u0004A\u0011\t3\u0002\u0013Ut\u0007/\u001a:tSN$HCA&f\u0011\u0015\u0011&\r1\u0001T\u0011\u00159\u0007\u0001\"\u0011i\u0003\u0011\u0011X-\u00193\u0016\u0005%4Hc\u00016\u0002\u0010Q\u00111n \t\u0004YF$hBA7p\u001d\t1f.C\u0001O\u0013\t\u0001X*A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001c(aA*fc*\u0011\u0001/\u0014\t\u0003kZd\u0001\u0001B\u0003xM\n\u0007\u0001PA\u0001U#\tIH\u0010\u0005\u0002Mu&\u001110\u0014\u0002\b\u001d>$\b.\u001b8h!\taU0\u0003\u0002\u007f\u001b\n\u0019\u0011I\\=\t\u0013\u0005\u0005a-!AA\u0004\u0005\r\u0011AC3wS\u0012,gnY3%cA)\u0011QAA\u0006i6\u0011\u0011q\u0001\u0006\u0004\u0003\u0013i\u0015a\u0002:fM2,7\r^\u0005\u0005\u0003\u001b\t9A\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0019\t\tB\u001aa\u0001'\u00061\u0001O]3gSbDq!!\u0006\u0001\t\u0003\n9\"A\u0003dY>\u001cX\rF\u0001L\u0011\u001d\tY\u0002\u0001C\u0005\u0003;\t\u0011c]3sS\u0006d\u0017N_3J]R|g)\u001b7f)\u0015Y\u0015qDA\u0012\u0011\u001d\t\t#!\u0007A\u0002M\u000bA\u0001]1uQ\"A\u0011QEA\r\u0001\u0004\t9#A\u0003wC2,X\rE\u0002M\u0003SI1!a\u000bN\u0005\u0019\te.\u001f*fM\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012a\u00053fg\u0016\u0014\u0018.\u00197ju\u00164%o\\7GS2,W\u0003BA\u001a\u0003\u007f!B!!\u000e\u0002HQ!\u0011qGA!!\u0015a\u0015\u0011HA\u001f\u0013\r\tY$\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007U\fy\u0004\u0002\u0004x\u0003[\u0011\r\u0001\u001f\u0005\t\u0003\u0007\ni\u0003q\u0001\u0002F\u0005\tQ\u000e\u0005\u0004\u0002\u0006\u0005-\u0011Q\b\u0005\b\u0003\u0013\ni\u00031\u0001T\u0003!1\u0017\u000e\\3oC6,\u0007")
public class ZooKeeperPersistenceEngine
extends PersistenceEngine
implements Logging {
    private final Serializer serializer;
    private final String WORKING_DIR;
    private final CuratorFramework zk;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    private CuratorFramework zk() {
        return this.zk;
    }

    @Override
    public void persist(String name, Object obj) {
        this.serializeIntoFile(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(name).toString(), obj);
    }

    @Override
    public void unpersist(String name) {
        this.zk().delete().forPath(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(name).toString());
    }

    @Override
    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk().getChildren().forPath(this.WORKING_DIR())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(prefix)))).flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(this.deserializeFromFile((String)filename, evidence$1)), Buffer$.MODULE$.canBuildFrom());
    }

    @Override
    public void close() {
        this.zk().close();
    }

    private void serializeIntoFile(String path, Object value) {
        ByteBuffer serialized = this.serializer().newInstance().serialize(value, ClassTag$.MODULE$.AnyRef());
        byte[] bytes = new byte[serialized.remaining()];
        serialized.get(bytes);
        ((PathAndBytesable)this.zk().create().withMode(CreateMode.PERSISTENT)).forPath(path, bytes);
    }

    private <T> Option<T> deserializeFromFile(String filename, ClassTag<T> m) {
        Some some;
        byte[] fileData = (byte[])this.zk().getData().forPath(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(filename).toString());
        try {
            some = new Some(this.serializer().newInstance().deserialize(ByteBuffer.wrap(fileData), m));
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while reading persisted file, deleting", e);
            this.zk().delete().forPath(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(filename).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public ZooKeeperPersistenceEngine(SparkConf conf, Serializer serializer) {
        this.serializer = serializer;
        Logging.$init$(this);
        this.WORKING_DIR = new StringBuilder(14).append(conf.get("spark.deploy.zookeeper.dir", "/spark")).append("/master_status").toString();
        this.zk = SparkCuratorUtil$.MODULE$.newClient(conf, SparkCuratorUtil$.MODULE$.newClient$default$2());
        SparkCuratorUtil$.MODULE$.mkdir(this.zk(), this.WORKING_DIR());
    }
}

