/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.ObjectInputStream;
import org.apache.spark.deploy.master.ApplicationInfo;
import org.apache.spark.deploy.master.DriverInfo;
import org.apache.spark.deploy.master.ExecutorDesc;
import org.apache.spark.deploy.master.WorkerState$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]g!B\u0001\u0003\u0001\u0019a!AC,pe.,'/\u00138g_*\u00111\u0001B\u0001\u0007[\u0006\u001cH/\u001a:\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00059!\u0012BA\u000b\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9\u0002A!b\u0001\n\u0003I\u0012AA5e\u0007\u0001)\u0012A\u0007\t\u00037\tr!\u0001\b\u0011\u0011\u0005uyQ\"\u0001\u0010\u000b\u0005}A\u0012A\u0002\u001fs_>$h(\u0003\u0002\"\u001f\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\ts\u0002\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\rIG\r\t\u0005\tQ\u0001\u0011)\u0019!C\u00013\u0005!\u0001n\\:u\u0011!Q\u0003A!A!\u0002\u0013Q\u0012!\u00025pgR\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\tA|'\u000f^\u000b\u0002]A\u0011abL\u0005\u0003a=\u00111!\u00138u\u0011!\u0011\u0004A!A!\u0002\u0013q\u0013!\u00029peR\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\u000b\r|'/Z:\t\u0011Y\u0002!\u0011!Q\u0001\n9\naaY8sKN\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\r5,Wn\u001c:z\u0011!Q\u0004A!A!\u0002\u0013q\u0013aB7f[>\u0014\u0018\u0010\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005AQM\u001c3q_&tG/F\u0001?!\ty$)D\u0001A\u0015\t\te!A\u0002sa\u000eL!a\u0011!\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\"AQ\t\u0001B\u0001B\u0003%a(A\u0005f]\u0012\u0004x.\u001b8uA!Aq\t\u0001BC\u0002\u0013\u0005\u0011$\u0001\u0007xK\n,\u0016.\u00113ee\u0016\u001c8\u000f\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003\u001b\u000359XMY+j\u0003\u0012$'/Z:tA!)1\n\u0001C\u0001\u0019\u00061A(\u001b8jiz\"\u0002\"T(Q#J\u001bF+\u0016\t\u0003\u001d\u0002i\u0011A\u0001\u0005\u0006/)\u0003\rA\u0007\u0005\u0006Q)\u0003\rA\u0007\u0005\u0006Y)\u0003\rA\f\u0005\u0006i)\u0003\rA\f\u0005\u0006q)\u0003\rA\f\u0005\u0006y)\u0003\rA\u0010\u0005\u0006\u000f*\u0003\rA\u0007\u0005\n/\u0002\u0001\r\u00111A\u0005\u0002a\u000b\u0011\"\u001a=fGV$xN]:\u0016\u0003e\u0003BAW0\u001bC6\t1L\u0003\u0002];\u00069Q.\u001e;bE2,'B\u00010\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003An\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002OE&\u00111M\u0001\u0002\r\u000bb,7-\u001e;pe\u0012+7o\u0019\u0005\nK\u0002\u0001\r\u00111A\u0005\u0002\u0019\fQ\"\u001a=fGV$xN]:`I\u0015\fHCA4k!\tq\u0001.\u0003\u0002j\u001f\t!QK\\5u\u0011\u001dYG-!AA\u0002e\u000b1\u0001\u001f\u00132\u0011%i\u0007\u00011A\u0001B\u0003&\u0011,\u0001\u0006fq\u0016\u001cW\u000f^8sg\u0002B#\u0001\\8\u0011\u00059\u0001\u0018BA9\u0010\u0005%!(/\u00198tS\u0016tG\u000fC\u0005t\u0001\u0001\u0007\t\u0019!C\u0001i\u00069AM]5wKJ\u001cX#A;\u0011\ti{&D\u001e\t\u0003\u001d^L!\u0001\u001f\u0002\u0003\u0015\u0011\u0013\u0018N^3s\u0013:4w\u000eC\u0005{\u0001\u0001\u0007\t\u0019!C\u0001w\u0006YAM]5wKJ\u001cx\fJ3r)\t9G\u0010C\u0004ls\u0006\u0005\t\u0019A;\t\u0013y\u0004\u0001\u0019!A!B\u0013)\u0018\u0001\u00033sSZ,'o\u001d\u0011)\u0005u|\u0007bCA\u0002\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000b\tQa\u001d;bi\u0016,\"!a\u0002\u0011\t\u0005%\u0011q\u0002\b\u0004\u001d\u0006-\u0011bAA\u0007\u0005\u0005Yqk\u001c:lKJ\u001cF/\u0019;f\u0013\u0011\t\t\"a\u0005\u0003\u000bY\u000bG.^3\n\u0007\u0005UqBA\u0006F]VlWM]1uS>t\u0007bCA\r\u0001\u0001\u0007\t\u0019!C\u0001\u00037\t\u0011b\u001d;bi\u0016|F%Z9\u0015\u0007\u001d\fi\u0002C\u0005l\u0003/\t\t\u00111\u0001\u0002\b!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0004\u0003\u0019\u0019H/\u0019;fA!\u001a\u0011qD8\t\u0015\u0005\u001d\u0002\u00011AA\u0002\u0013\u0005Q&A\u0005d_J,7/V:fI\"Y\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0017\u00035\u0019wN]3t+N,Gm\u0018\u0013fcR\u0019q-a\f\t\u0011-\fI#!AA\u00029B!\"a\r\u0001\u0001\u0004\u0005\t\u0015)\u0003/\u0003)\u0019wN]3t+N,G\r\t\u0015\u0004\u0003cy\u0007BCA\u001d\u0001\u0001\u0007\t\u0019!C\u0001[\u0005QQ.Z7pef,6/\u001a3\t\u0017\u0005u\u0002\u00011AA\u0002\u0013\u0005\u0011qH\u0001\u000f[\u0016lwN]=Vg\u0016$w\fJ3r)\r9\u0017\u0011\t\u0005\tW\u0006m\u0012\u0011!a\u0001]!Q\u0011Q\t\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0018\u0002\u00175,Wn\u001c:z+N,G\r\t\u0015\u0004\u0003\u0007z\u0007bCA&\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001b\nQ\u0002\\1ti\"+\u0017M\u001d;cK\u0006$XCAA(!\rq\u0011\u0011K\u0005\u0004\u0003'z!\u0001\u0002'p]\u001eD1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002Z\u0005\tB.Y:u\u0011\u0016\f'\u000f\u001e2fCR|F%Z9\u0015\u0007\u001d\fY\u0006C\u0005l\u0003+\n\t\u00111\u0001\u0002P!Y\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA(\u00039a\u0017m\u001d;IK\u0006\u0014HOY3bi\u0002B3!!\u0018p\u0011\u0019\t)\u0007\u0001C\u0001[\u0005I1m\u001c:fg\u001a\u0013X-\u001a\u0005\u0007\u0003S\u0002A\u0011A\u0017\u0002\u00155,Wn\u001c:z\rJ,W\rC\u0004\u0002n\u0001!I!a\u001c\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000fF\u0002h\u0003cB\u0001\"a\u001d\u0002l\u0001\u0007\u0011QO\u0001\u0003S:\u0004B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0002j_*\u0011\u0011qP\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0004\u0006e$!E(cU\u0016\u001cG/\u00138qkR\u001cFO]3b[\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015\u0001B5oSR$\u0012a\u001a\u0005\u0007\u0003\u001b\u0003A\u0011A\r\u0002\u0011!|7\u000f\u001e)peRDq!!%\u0001\t\u0003\t\u0019*A\u0006bI\u0012,\u00050Z2vi>\u0014HcA4\u0002\u0016\"9\u0011qSAH\u0001\u0004\t\u0017\u0001B3yK\u000eDq!a'\u0001\t\u0003\ti*\u0001\bsK6|g/Z#yK\u000e,Ho\u001c:\u0015\u0007\u001d\fy\nC\u0004\u0002\u0018\u0006e\u0005\u0019A1\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\u0006Y\u0001.Y:Fq\u0016\u001cW\u000f^8s)\u0011\t9+!,\u0011\u00079\tI+C\u0002\u0002,>\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u00020\u0006\u0005\u0006\u0019AAY\u0003\r\t\u0007\u000f\u001d\t\u0004\u001d\u0006M\u0016bAA[\u0005\ty\u0011\t\u001d9mS\u000e\fG/[8o\u0013:4w\u000eC\u0004\u0002:\u0002!\t!a/\u0002\u0013\u0005$G\r\u0012:jm\u0016\u0014HcA4\u0002>\"9\u0011qXA\\\u0001\u00041\u0018A\u00023sSZ,'\u000fC\u0004\u0002D\u0002!\t!!2\u0002\u0019I,Wn\u001c<f\tJLg/\u001a:\u0015\u0007\u001d\f9\rC\u0004\u0002@\u0006\u0005\u0007\u0019\u0001<\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006A1/\u001a;Ti\u0006$X\rF\u0002h\u0003\u001fD\u0001\"a\u0001\u0002J\u0002\u0007\u0011q\u0001\u0005\b\u0003'\u0004A\u0011AAk\u0003\u001dI7/\u00117jm\u0016$\"!a*")
public class WorkerInfo
implements Serializable {
    private final String id;
    private final String host;
    private final int port;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef endpoint;
    private final String webUiAddress;
    private transient HashMap<String, ExecutorDesc> executors;
    private transient HashMap<String, DriverInfo> drivers;
    private transient Enumeration.Value state;
    private transient int coresUsed;
    private transient int memoryUsed;
    private transient long lastHeartbeat;

    public String id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public String webUiAddress() {
        return this.webUiAddress;
    }

    public HashMap<String, ExecutorDesc> executors() {
        return this.executors;
    }

    public void executors_$eq(HashMap<String, ExecutorDesc> x$1) {
        this.executors = x$1;
    }

    public HashMap<String, DriverInfo> drivers() {
        return this.drivers;
    }

    public void drivers_$eq(HashMap<String, DriverInfo> x$1) {
        this.drivers = x$1;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public int coresUsed() {
        return this.coresUsed;
    }

    public void coresUsed_$eq(int x$1) {
        this.coresUsed = x$1;
    }

    public int memoryUsed() {
        return this.memoryUsed;
    }

    public void memoryUsed_$eq(int x$1) {
        this.memoryUsed = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public int coresFree() {
        return this.cores() - this.coresUsed();
    }

    public int memoryFree() {
        return this.memory() - this.memoryUsed();
    }

    private void readObject(ObjectInputStream in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            in.defaultReadObject();
            this.init();
        });
    }

    private void init() {
        this.executors_$eq((HashMap<String, ExecutorDesc>)new HashMap());
        this.drivers_$eq((HashMap<String, DriverInfo>)new HashMap());
        this.state_$eq(WorkerState$.MODULE$.ALIVE());
        this.coresUsed_$eq(0);
        this.memoryUsed_$eq(0);
        this.lastHeartbeat_$eq(System.currentTimeMillis());
    }

    public String hostPort() {
        Predef$.MODULE$.assert(this.port() > 0);
        return new StringBuilder(1).append(this.host()).append(":").append(this.port()).toString();
    }

    public void addExecutor(ExecutorDesc exec) {
        this.executors().update((Object)exec.fullId(), (Object)exec);
        this.coresUsed_$eq(this.coresUsed() + exec.cores());
        this.memoryUsed_$eq(this.memoryUsed() + exec.memory());
    }

    public void removeExecutor(ExecutorDesc exec) {
        block0: {
            if (!this.executors().contains((Object)exec.fullId())) break block0;
            this.executors().$minus$eq((Object)exec.fullId());
            this.coresUsed_$eq(this.coresUsed() - exec.cores());
            this.memoryUsed_$eq(this.memoryUsed() - exec.memory());
        }
    }

    public boolean hasExecutor(ApplicationInfo app) {
        return this.executors().values().exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$hasExecutor$1(app, x$1)));
    }

    public void addDriver(DriverInfo driver) {
        this.drivers().update((Object)driver.id(), (Object)driver);
        this.memoryUsed_$eq(this.memoryUsed() + driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() + driver.desc().cores());
    }

    public void removeDriver(DriverInfo driver) {
        this.drivers().$minus$eq((Object)driver.id());
        this.memoryUsed_$eq(this.memoryUsed() - driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() - driver.desc().cores());
    }

    public void setState(Enumeration.Value state) {
        this.state_$eq(state);
    }

    public boolean isAlive() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = WorkerState$.MODULE$.ALIVE();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasExecutor$1(ApplicationInfo app$1, ExecutorDesc x$1) {
        ApplicationInfo applicationInfo = x$1.application();
        ApplicationInfo applicationInfo2 = app$1;
        return !(applicationInfo != null ? !applicationInfo.equals(applicationInfo2) : applicationInfo2 != null);
    }

    public WorkerInfo(String id, String host, int port, int cores, int memory, RpcEndpointRef endpoint, String webUiAddress) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.cores = cores;
        this.memory = memory;
        this.endpoint = endpoint;
        this.webUiAddress = webUiAddress;
        Utils$.MODULE$.checkHost(host);
        Predef$.MODULE$.assert(port > 0);
        this.init();
    }
}

