/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\u0001\u0003\u0001\ta!a\u0007$jY\u0016\u001c\u0016p\u001d;f[B+'o]5ti\u0016t7-Z#oO&tWM\u0003\u0002\u0004\t\u00051Q.Y:uKJT!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0012!\u0016\u00148/[:uK:\u001cW-\u00128hS:,\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0004I&\u00148\u0001A\u000b\u00027A\u0011A$\n\b\u0003;\r\u0002\"AH\u0011\u000e\u0003}Q!\u0001I\r\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0003\u0019\u0001&/\u001a3fM&\u0011ae\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\n\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\t\u0011L'\u000f\t\u0005\tW\u0001\u0011)\u0019!C\u0001Y\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u00035\u0002\"A\f\u0019\u000e\u0003=R!a\u000b\u0004\n\u0005Ez#AC*fe&\fG.\u001b>fe\"A1\u0007\u0001B\u0001B\u0003%Q&A\u0006tKJL\u0017\r\\5{KJ\u0004\u0003\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\bF\u00028qe\u0002\"A\u0004\u0001\t\u000ba!\u0004\u0019A\u000e\t\u000b-\"\u0004\u0019A\u0017\t\u000bm\u0002A\u0011\t\u001f\u0002\u000fA,'o]5tiR\u0019Q(Q\"\u0011\u0005yzT\"A\u0011\n\u0005\u0001\u000b#\u0001B+oSRDQA\u0011\u001eA\u0002m\tAA\\1nK\")AI\u000fa\u0001\u000b\u0006\u0019qN\u00196\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u0002M\u000f\n1qJ\u00196fGRDQA\u0014\u0001\u0005B=\u000b\u0011\"\u001e8qKJ\u001c\u0018n\u001d;\u0015\u0005u\u0002\u0006\"\u0002\"N\u0001\u0004Y\u0002\"\u0002*\u0001\t\u0003\u001a\u0016\u0001\u0002:fC\u0012,\"\u0001V1\u0015\u0005U\u0013HC\u0001,k!\r9Fl\u0018\b\u00031js!AH-\n\u0003\tJ!aW\u0011\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0004'\u0016\f(BA.\"!\t\u0001\u0017\r\u0004\u0001\u0005\u000b\t\f&\u0019A2\u0003\u0003Q\u000b\"\u0001Z4\u0011\u0005y*\u0017B\u00014\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u00105\n\u0005%\f#aA!os\"91.UA\u0001\u0002\ba\u0017AC3wS\u0012,gnY3%cA\u0019Q\u000e]0\u000e\u00039T!a\\\u0011\u0002\u000fI,g\r\\3di&\u0011\u0011O\u001c\u0002\t\u00072\f7o\u001d+bO\")1/\u0015a\u00017\u00051\u0001O]3gSbDQ!\u001e\u0001\u0005\nY\f\u0011c]3sS\u0006d\u0017N_3J]R|g)\u001b7f)\rito \u0005\u0006qR\u0004\r!_\u0001\u0005M&dW\r\u0005\u0002{{6\t1P\u0003\u0002}\u0013\u0006\u0011\u0011n\\\u0005\u0003}n\u0014AAR5mK\"9\u0011\u0011\u0001;A\u0002\u0005\r\u0011!\u0002<bYV,\u0007c\u0001 \u0002\u0006%\u0019\u0011qA\u0011\u0003\r\u0005s\u0017PU3g\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\t1\u0003Z3tKJL\u0017\r\\5{K\u001a\u0013x.\u001c$jY\u0016,B!a\u0004\u0002\u0016Q!\u0011\u0011CA\u000f)\u0011\t\u0019\"a\u0006\u0011\u0007\u0001\f)\u0002\u0002\u0004c\u0003\u0013\u0011\ra\u0019\u0005\t\u00033\tI\u0001q\u0001\u0002\u001c\u0005\tQ\u000e\u0005\u0003na\u0006M\u0001B\u0002=\u0002\n\u0001\u0007\u0011\u0010")
public class FileSystemPersistenceEngine
extends PersistenceEngine
implements Logging {
    private final String dir;
    private final Serializer serializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String dir() {
        return this.dir;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public void persist(String name, Object obj) {
        this.serializeIntoFile(new File(new StringBuilder(0).append(this.dir()).append(File.separator).append(name).toString()), obj);
    }

    @Override
    public void unpersist(String name) {
        block0: {
            File f = new File(new StringBuilder(0).append(this.dir()).append(File.separator).append(name).toString());
            if (f.delete()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(f.getPath()).toString());
        }
    }

    @Override
    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        File[] files = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.dir()).listFiles())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemPersistenceEngine.$anonfun$read$1(prefix, x$1)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)file -> this.deserializeFromFile((File)file, evidence$1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private void serializeIntoFile(File file, Object value) {
        boolean created = file.createNewFile();
        if (!created) {
            throw new IllegalStateException(new StringBuilder(23).append("Could not create file: ").append(file).toString());
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        ObjectRef out = ObjectRef.create(null);
        Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
            out$1.elem = this.serializer().newInstance().serializeStream(fileOut);
            return ((SerializationStream)out$1.elem).writeObject(value, ClassTag$.MODULE$.AnyRef());
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                fileOut.close();
                if ((SerializationStream)out$1.elem == null) break block0;
                ((SerializationStream)out$1.elem).close();
            }
        });
    }

    private <T> T deserializeFromFile(File file, ClassTag<T> m) {
        T t;
        FileInputStream fileIn = new FileInputStream(file);
        DeserializationStream in = null;
        try {
            in = this.serializer().newInstance().deserializeStream(fileIn);
            t = in.readObject(m);
        }
        finally {
            fileIn.close();
            if (in != null) {
                in.close();
            }
        }
        return t;
    }

    public static final /* synthetic */ boolean $anonfun$read$1(String prefix$1, File x$1) {
        return x$1.getName().startsWith(prefix$1);
    }

    public FileSystemPersistenceEngine(String dir, Serializer serializer) {
        this.dir = dir;
        this.serializer = serializer;
        Logging.$init$(this);
        new File(dir).mkdir();
    }
}

