/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.ApplicationStoreInfo;
import org.apache.spark.deploy.history.config$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\t5\u0011\u0001\u0004S5ti>\u0014\u0018pU3sm\u0016\u0014H)[:l\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0004iSN$xN]=\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012\u0001B2p]\u001a\u0004\"!\b\u0010\u000e\u0003\u0019I!a\b\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\tA\fG\u000f\u001b\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\n!![8\u000b\u0003\u001d\nAA[1wC&\u0011\u0011\u0006\n\u0002\u0005\r&dW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003\u001da\u0017n\u001d;j]\u001e\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u000f-48\u000f^8sK*\u0011\u0011GB\u0001\u0005kRLG.\u0003\u00024]\t91JV*u_J,\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000b\rdwnY6\u0011\u0005]BT\"\u0001\u0019\n\u0005e\u0002$!B\"m_\u000e\\\u0007\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\bF\u0003>\u007f\u0001\u000b%\t\u0005\u0002?\u00015\t!\u0001C\u0003\u001cu\u0001\u0007A\u0004C\u0003\"u\u0001\u0007!\u0005C\u0003,u\u0001\u0007A\u0006C\u00036u\u0001\u0007a\u0007C\u0004E\u0001\t\u0007I\u0011B#\u0002\u0017\u0005\u0004\bo\u0015;pe\u0016$\u0015N]\u000b\u0002E!1q\t\u0001Q\u0001\n\t\nA\"\u00199q'R|'/\u001a#je\u0002Bq!\u0013\u0001C\u0002\u0013%Q)A\u0006u[B\u001cFo\u001c:f\t&\u0014\bBB&\u0001A\u0003%!%\u0001\u0007u[B\u001cFo\u001c:f\t&\u0014\b\u0005C\u0004N\u0001\t\u0007I\u0011\u0002(\u0002\u00115\f\u00070V:bO\u0016,\u0012a\u0014\t\u0003\u001fAK!!\u0015\t\u0003\t1{gn\u001a\u0005\u0007'\u0002\u0001\u000b\u0011B(\u0002\u00135\f\u00070V:bO\u0016\u0004\u0003bB+\u0001\u0005\u0004%IAV\u0001\rGV\u0014(/\u001a8u+N\fw-Z\u000b\u0002/B\u0011\u0001LX\u0007\u00023*\u0011!lW\u0001\u0007CR|W.[2\u000b\u0005qk\u0016AC2p]\u000e,(O]3oi*\u0011\u0011GJ\u0005\u0003?f\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019\t\u0007\u0001)A\u0005/\u0006i1-\u001e:sK:$Xk]1hK\u0002Bqa\u0019\u0001C\u0002\u0013%a+\u0001\bd_6l\u0017\u000e\u001e;fIV\u001b\u0018mZ3\t\r\u0015\u0004\u0001\u0015!\u0003X\u0003=\u0019w.\\7jiR,G-V:bO\u0016\u0004\u0003bB4\u0001\u0005\u0004%I\u0001[\u0001\u0007C\u000e$\u0018N^3\u0016\u0003%\u0004BA[8r\u001f6\t1N\u0003\u0002m[\u00069Q.\u001e;bE2,'B\u00018\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a.\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0010eR|\u0018BA:\u0011\u0005\u0019!V\u000f\u001d7feA\u0011Q\u000f \b\u0003mj\u0004\"a\u001e\t\u000e\u0003aT!!\u001f\u0007\u0002\rq\u0012xn\u001c;?\u0013\tY\b#\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>\u0011!\u0011y\u0011\u0011\u0001;\n\u0007\u0005\r\u0001C\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003j\u0003\u001d\t7\r^5wK\u0002Bq!a\u0003\u0001\t\u0003\ti!\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!a\u0004\u0011\u0007=\t\t\"C\u0002\u0002\u0014A\u0011A!\u00168ji\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011!\u00027fCN,GCBA\u000e\u0003\u001f\n\u0019\u0006\u0005\u0003\u0002\u001e\u0005}Q\"\u0001\u0001\u0007\u000f\u0005\u0005\u0002\u0001\u0001\u0002\u0002$\t)A*Z1tKN\u0019\u0011q\u0004\b\t\u0015\u0005\u001d\u0012q\u0004BC\u0002\u0013\u0005Q)A\u0004u[B\u0004\u0016\r\u001e5\t\u0015\u0005-\u0012q\u0004B\u0001B\u0003%!%\u0001\u0005u[B\u0004\u0016\r\u001e5!\u0011)\ty#a\b\u0003\u0006\u0004%IAT\u0001\u0007Y\u0016\f7/\u001a3\t\u0015\u0005M\u0012q\u0004B\u0001B\u0003%q*A\u0004mK\u0006\u001cX\r\u001a\u0011\t\u000fm\ny\u0002\"\u0001\u00028Q1\u00111DA\u001d\u0003wAq!a\n\u00026\u0001\u0007!\u0005C\u0004\u00020\u0005U\u0002\u0019A(\t\u0011\u0005}\u0012q\u0004C\u0001\u0003\u0003\naaY8n[&$H#\u0002\u0012\u0002D\u0005\u001d\u0003bBA#\u0003{\u0001\r\u0001^\u0001\u0006CB\u0004\u0018\n\u001a\u0005\b\u0003\u0013\ni\u00041\u0001\u0000\u0003%\tG\u000f^3naRLE\r\u0003\u0005\u0002N\u0005}A\u0011AA\u0007\u0003!\u0011x\u000e\u001c7cC\u000e\\\u0007bBA)\u0003+\u0001\raT\u0001\rKZ,g\u000e\u001e'pONK'0\u001a\u0005\u000b\u0003+\n)\u0002%AA\u0002\u0005]\u0013\u0001D5t\u0007>l\u0007O]3tg\u0016$\u0007cA\b\u0002Z%\u0019\u00111\f\t\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014!C8qK:\u001cFo\u001c:f)\u0019\t\u0019'!\u001a\u0002hA!q\"!\u0001#\u0011\u001d\t)%!\u0018A\u0002QDq!!\u0013\u0002^\u0001\u0007q\u0010C\u0004\u0002l\u0001!\t!!\u001c\u0002\u000fI,G.Z1tKRA\u0011qBA8\u0003c\n\u0019\bC\u0004\u0002F\u0005%\u0004\u0019\u0001;\t\u000f\u0005%\u0013\u0011\u000ea\u0001\u007f\"Q\u0011QOA5!\u0003\u0005\r!a\u0016\u0002\r\u0011,G.\u001a;f\u0011\u001d\tI\b\u0001C\u0001\u0003w\nq\"\u00199qe>D\u0018.\\1uKNK'0\u001a\u000b\u0006\u001f\u0006u\u0014q\u0010\u0005\b\u0003#\n9\b1\u0001P\u0011!\t)&a\u001eA\u0002\u0005]\u0003bBAB\u0001\u0011\u0005\u0011QQ\u0001\u0005MJ,W\rF\u0001P\u0011\u001d\tI\t\u0001C\u0001\u0003\u000b\u000b\u0011bY8n[&$H/\u001a3\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\u0006YA-\u001a7fi\u0016\u001cFo\u001c:f)\u0011\ty!!%\t\r\u0005\nY\t1\u0001#\u0011\u001d\t)\n\u0001C\u0005\u0003/\u000b\u0001\"\\1lKJ{w.\u001c\u000b\u0005\u0003\u001f\tI\nC\u0004\u0002\u001c\u0006M\u0005\u0019A(\u0002\tML'0\u001a\u0005\b\u0003?\u0003A\u0011BAQ\u00031\t\u0007\u000f]*u_J,\u0007+\u0019;i)\u0015\u0011\u00131UAS\u0011\u001d\t)%!(A\u0002QDq!!\u0013\u0002\u001e\u0002\u0007q\u0010C\u0004\u0002*\u0002!I!a+\u0002!U\u0004H-\u0019;f\u0003\u000e\u001cWm]:US6,GCBA\b\u0003[\u000by\u000bC\u0004\u0002F\u0005\u001d\u0006\u0019\u0001;\t\u000f\u0005%\u0013q\u0015a\u0001\u007f\"9\u00111\u0017\u0001\u0005\n\u0005U\u0016aC;qI\u0006$X-V:bO\u0016$b!a\u0004\u00028\u0006m\u0006bBA]\u0003c\u0003\raT\u0001\u0006I\u0016dG/\u0019\u0005\u000b\u0003\u0013\u000b\t\f%AA\u0002\u0005]\u0003\u0002CA`\u0001\u0011\u0005!!!1\u0002\rML'0Z(g)\ry\u00151\u0019\u0005\u0007C\u0005u\u0006\u0019\u0001\u0012\t\u0013\u0005\u001d\u0007!%A\u0005\u0002\u0005%\u0017!\u0005:fY\u0016\f7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001a\u0016\u0005\u0003/\nim\u000b\u0002\u0002PB!\u0011\u0011[An\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017!C;oG\",7m[3e\u0015\r\tI\u000eE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAo\u0003'\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\t\u000fAI\u0001\n\u0003\tI-A\bmK\u0006\u001cX\r\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)\u000fAI\u0001\n\u0013\tI-A\u000bva\u0012\fG/Z+tC\u001e,G\u0005Z3gCVdG\u000f\n\u001a")
public class HistoryServerDiskManager
implements Logging {
    private final KVStore listing;
    private final Clock clock;
    private final File appStoreDir;
    private final File tmpStoreDir;
    private final long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    private final AtomicLong currentUsage;
    private final AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    private final HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private File appStoreDir() {
        return this.appStoreDir;
    }

    private File tmpStoreDir() {
        return this.tmpStoreDir;
    }

    public long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    }

    private AtomicLong currentUsage() {
        return this.currentUsage;
    }

    public AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    }

    public HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    }

    public void initialize() {
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(this.sizeOf(this.appStoreDir()), true);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tmpStoreDir().listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$1(x$1)));
        Seq orphans = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.listing.view(ApplicationStoreInfo.class)).asScala()).filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$2(info)))).toSeq();
        orphans.foreach((Function1 & Serializable & scala.Serializable)info -> {
            this.listing.delete(info.getClass(), (Object)info.path());
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Initialized disk manager: ").append(new StringBuilder(18).append("current usage = ").append(Utils$.MODULE$.bytesToString(this.currentUsage().get())).append(", ").toString()).append(new StringBuilder(12).append("max usage = ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).toString()).toString());
    }

    public Lease lease(long eventLogSize, boolean isCompressed) {
        long needed = this.approximateSize(eventLogSize, isCompressed);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(needed);
        File tmp = Utils$.MODULE$.createTempDir(this.tmpStoreDir().getPath(), "appstore");
        Utils$.MODULE$.chmod700(tmp);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(needed, this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
        long current = this.currentUsage().get();
        if (current > this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Lease of ").append(Utils$.MODULE$.bytesToString(needed)).append(" may cause usage to exceed max ").append(new StringBuilder(5).append("(").append(Utils$.MODULE$.bytesToString(current)).append(" > ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).append(")").toString()).toString());
        }
        return new Lease(this, tmp, needed);
    }

    public boolean lease$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Option<File> openStore(String appId, Option<String> attemptId) {
        void var3_6;
        None$ none$;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            None$ none$2;
            File path2 = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
            if (path2.isDirectory()) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)this.sizeOf(path2)));
                none$2 = new Some((Object)path2);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ storePath = none$;
        storePath.foreach((Function1 & Serializable & scala.Serializable)path -> {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(appId, (Option<String>)attemptId);
            return BoxedUnit.UNIT;
        });
        return var3_6;
    }

    public void release(String appId, Option<String> attemptId, boolean delete) {
        Option option;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            option = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().remove((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId));
        }
        Option oldSizeOpt = option;
        oldSizeOpt.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)oldSize -> {
            block2: {
                File path = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-oldSize, true);
                if (!path.isDirectory()) break block2;
                if (delete) {
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(path);
                } else {
                    long newSize = this.sizeOf(path);
                    ApplicationStoreInfo qual$1 = (ApplicationStoreInfo)$this.listing.read(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
                    long x$2 = newSize;
                    String x$3 = qual$1.copy$default$1();
                    long x$4 = qual$1.copy$default$2();
                    String x$5 = qual$1.copy$default$3();
                    Option<String> x$6 = qual$1.copy$default$4();
                    ApplicationStoreInfo newInfo = qual$1.copy(x$3, x$4, x$5, x$6, x$2);
                    $this.listing.write((Object)newInfo);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
                }
            }
        });
    }

    public boolean release$default$3() {
        return false;
    }

    public long approximateSize(long eventLogSize, boolean isCompressed) {
        return isCompressed ? eventLogSize * 2L : eventLogSize / 2L;
    }

    public long free() {
        return package$.MODULE$.max(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() - this.currentUsage().get(), 0L);
    }

    public long committed() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get();
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(File path) {
        FileUtils.deleteDirectory((File)path);
        this.listing.delete(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(long size) {
        block2: {
            if (this.free() >= size) break block2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Not enough free space, looking at candidates for deletion...");
            ListBuffer evicted = new ListBuffer();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.listing.view(ApplicationStoreInfo.class).index("lastAccess").closeableIterator(), (Function1 & Serializable & scala.Serializable)iter -> {
                HistoryServerDiskManager.$anonfun$makeRoom$3(this, size, evicted, iter);
                return BoxedUnit.UNIT;
            });
            if (evicted.nonEmpty()) {
                long freed = BoxesRunTime.unboxToLong((Object)((TraversableForwarder)evicted.map((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToLong((long)HistoryServerDiskManager.$anonfun$makeRoom$4(this, info)), ListBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleted ").append(evicted.size()).append(" store(s) to free ").append(Utils$.MODULE$.bytesToString(freed)).append(" ").append(new StringBuilder(12).append("(target = ").append(Utils$.MODULE$.bytesToString(size)).append(").").toString()).toString());
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unable to free any space to make room for ").append(Utils$.MODULE$.bytesToString(size)).append(".").toString());
            }
        }
    }

    public File org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(String appId, Option<String> attemptId) {
        String fileName = new StringBuilder(4).append(appId).append(attemptId.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("_").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(".ldb").toString();
        return new File(this.appStoreDir(), fileName);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(String appId, Option<String> attemptId) {
        File path = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
        ApplicationStoreInfo info = new ApplicationStoreInfo(path.getAbsolutePath(), this.clock.getTimeMillis(), appId, attemptId, this.sizeOf(path));
        this.listing.write((Object)info);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(long delta, boolean committed) {
        long updatedCommitted;
        long updated = this.currentUsage().addAndGet(delta);
        if (updated < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updated).append(", delta = ").append(delta).append(")").toString());
        }
        if (committed && (updatedCommitted = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().addAndGet(delta)) < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updatedCommitted).append(", delta = ").append(delta).append(")").toString());
        }
    }

    public boolean org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2() {
        return false;
    }

    public long sizeOf(File path) {
        return FileUtils.sizeOf((File)path);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(File x$1) {
        return FileUtils.deleteQuietly((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$2(ApplicationStoreInfo info) {
        return !new File(info.path()).exists();
    }

    public static final /* synthetic */ void $anonfun$makeRoom$3(HistoryServerDiskManager $this, long size$1, ListBuffer evicted$1, KVStoreIterator iter) {
        long needed = size$1;
        while (needed > 0L && iter.hasNext()) {
            boolean bl;
            ApplicationStoreInfo info = (ApplicationStoreInfo)iter.next();
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                bl = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)info.appId()), info.attemptId()));
            }
            boolean isActive = bl;
            if (isActive) continue;
            evicted$1.$plus$eq((Object)info);
            needed -= info.size();
        }
    }

    public static final /* synthetic */ long $anonfun$makeRoom$4(HistoryServerDiskManager $this, ApplicationStoreInfo info) {
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting store for ").append(info.appId()).append("/").append(info.attemptId()).append(".").toString());
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(new File(info.path()));
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-info.size(), true);
        return info.size();
    }

    public HistoryServerDiskManager(SparkConf conf, File path, KVStore listing, Clock clock) {
        this.listing = listing;
        this.clock = clock;
        Logging.$init$(this);
        this.appStoreDir = new File(path, "apps");
        if (!this.appStoreDir().isDirectory() && !this.appStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Failed to create app directory (").append(this.appStoreDir()).append(").").toString());
        }
        this.tmpStoreDir = new File(path, "temp");
        if (!this.tmpStoreDir().isDirectory() && !this.tmpStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Failed to create temp directory (").append(this.tmpStoreDir()).append(").").toString());
        }
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage = BoxesRunTime.unboxToLong((Object)conf.get(config$.MODULE$.MAX_LOCAL_DISK_USAGE()));
        this.currentUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active = new HashMap();
    }

    public class Lease {
        private final File tmpPath;
        private final long leased;
        public final /* synthetic */ HistoryServerDiskManager $outer;

        public File tmpPath() {
            return this.tmpPath;
        }

        private long leased() {
            return this.leased;
        }

        /*
         * WARNING - void declaration
         */
        public File commit(String appId, Option<String> attemptId) {
            void var3_3;
            File dst = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                Predef$.MODULE$.require(!this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cannot commit lease for active application ").append(appId).append(" / ").append(attemptId).toString());
                if (dst.isDirectory()) {
                    long size = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-size, true);
                }
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            long newSize = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(this.tmpPath());
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(newSize);
            this.tmpPath().renameTo(dst);
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
            if (this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get() > this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
                String current = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get());
                String max = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage());
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Commit of application ").append(appId).append(" / ").append(attemptId).append(" causes maximum disk usage to be ").append(new StringBuilder(14).append("exceeded (").append(current).append(" > ").append(max).append(")").toString()).toString());
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap2 = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap2) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)newSize));
            }
            return var3_3;
        }

        public void rollback() {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            FileUtils.deleteDirectory((File)this.tmpPath());
        }

        public /* synthetic */ HistoryServerDiskManager org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer() {
            return this.$outer;
        }

        public Lease(HistoryServerDiskManager $outer, File tmpPath, long leased) {
            this.tmpPath = tmpPath;
            this.leased = leased;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

