/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import javax.servlet.DispatcherType;
import org.apache.spark.deploy.history.ApplicationCacheCheckFilter;
import org.apache.spark.deploy.history.ApplicationCacheOperations;
import org.apache.spark.deploy.history.CacheEntry;
import org.apache.spark.deploy.history.CacheKey;
import org.apache.spark.deploy.history.CacheMetrics;
import org.apache.spark.deploy.history.LoadedAppUI;
import org.apache.spark.internal.Logging;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import org.spark_project.guava.cache.CacheBuilder;
import org.spark_project.guava.cache.CacheLoader;
import org.spark_project.guava.cache.LoadingCache;
import org.spark_project.guava.cache.RemovalListener;
import org.spark_project.guava.cache.RemovalNotification;
import org.spark_project.guava.util.concurrent.UncheckedExecutionException;
import org.spark_project.jetty.servlet.FilterHolder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tUa!B\u0001\u0003\u0001\ta!\u0001E!qa2L7-\u0019;j_:\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0004iSN$xN]=\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q9R\"A\u000b\u000b\u0005Y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005a)\"a\u0002'pO\u001eLgn\u001a\u0005\t5\u0001\u0011)\u0019!C\u00019\u0005Qq\u000e]3sCRLwN\\:\u0004\u0001U\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\tQ\u0012\t\u001d9mS\u000e\fG/[8o\u0007\u0006\u001c\u0007.Z(qKJ\fG/[8og\"A!\u0005\u0001B\u0001B\u0003%Q$A\u0006pa\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002)I,G/Y5oK\u0012\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t+\u00051\u0003C\u0001\b(\u0013\tAsBA\u0002J]RD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0016e\u0016$\u0018-\u001b8fI\u0006\u0003\b\u000f\\5dCRLwN\\:!\u0011!a\u0003A!b\u0001\n\u0003i\u0013!B2m_\u000e\\W#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011\u0001B;uS2L!a\r\u0019\u0003\u000b\rcwnY6\t\u0011U\u0002!\u0011!Q\u0001\n9\naa\u00197pG.\u0004\u0003\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0003:umb\u0004C\u0001\u0010\u0001\u0011\u0015Qb\u00071\u0001\u001e\u0011\u0015!c\u00071\u0001'\u0011\u0015ac\u00071\u0001/\u0011\u001dq\u0004A1A\u0005\n}\n\u0011\"\u00199q\u0019>\fG-\u001a:\u0016\u0003\u0001\u0003B!\u0011&M\u001f6\t!I\u0003\u0002D\t\u0006)1-Y2iK*\u0011QIR\u0001\u0007G>lWn\u001c8\u000b\u0005\u001dC\u0015AB4p_\u001edWMC\u0001J\u0003\r\u0019w.\\\u0005\u0003\u0017\n\u00131bQ1dQ\u0016du.\u00193feB\u0011a$T\u0005\u0003\u001d\n\u0011\u0001bQ1dQ\u0016\\U-\u001f\t\u0003=AK!!\u0015\u0002\u0003\u0015\r\u000b7\r[3F]R\u0014\u0018\u0010\u0003\u0004T\u0001\u0001\u0006I\u0001Q\u0001\u000bCB\u0004Hj\\1eKJ\u0004\u0003bB+\u0001\u0005\u0004%IAV\u0001\u0010e\u0016lwN^1m\u0019&\u001cH/\u001a8feV\tqKE\u0002Y9\u00124A!\u0017.\u0001/\naAH]3gS:,W.\u001a8u}!11\f\u0001Q\u0001\n]\u000b\u0001C]3n_Z\fG\u000eT5ti\u0016tWM\u001d\u0011\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n1qJ\u00196fGR\u0004B!Q3M\u001f&\u0011aM\u0011\u0002\u0010%\u0016lwN^1m\u0019&\u001cH/\u001a8fe\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0017\u0001C1qa\u000e\u000b7\r[3\u0016\u0003)\u0004B!Q6M\u001f&\u0011AN\u0011\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00026\u0002\u0013\u0005\u0004\boQ1dQ\u0016\u0004\u0003b\u00029\u0001\u0005\u0004%\t!]\u0001\b[\u0016$(/[2t+\u0005\u0011\bC\u0001\u0010t\u0013\t!(A\u0001\u0007DC\u000eDW-T3ue&\u001c7\u000f\u0003\u0004w\u0001\u0001\u0006IA]\u0001\t[\u0016$(/[2tA!)\u0001\u0010\u0001C\u0001s\u0006\u0019q-\u001a;\u0015\t=S\u0018q\u0002\u0005\u0006w^\u0004\r\u0001`\u0001\u0006CB\u0004\u0018\n\u001a\t\u0004{\u0006%ab\u0001@\u0002\u0006A\u0011qpD\u0007\u0003\u0003\u0003Q1!a\u0001\u001c\u0003\u0019a$o\\8u}%\u0019\u0011qA\b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9a\u0004\u0005\n\u0003#9\b\u0013!a\u0001\u0003'\t\u0011\"\u0019;uK6\u0004H/\u00133\u0011\t9\t)\u0002`\u0005\u0004\u0003/y!AB(qi&|g\u000eC\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0017]LG\u000f[*qCJ\\W+S\u000b\u0005\u0003?\t9\u0003\u0006\u0004\u0002\"\u0005=\u0013\u0011\u000b\u000b\u0005\u0003G\tI\u0004\u0005\u0003\u0002&\u0005\u001dB\u0002\u0001\u0003\t\u0003S\tIB1\u0001\u0002,\t\tA+\u0005\u0003\u0002.\u0005M\u0002c\u0001\b\u00020%\u0019\u0011\u0011G\b\u0003\u000f9{G\u000f[5oOB\u0019a\"!\u000e\n\u0007\u0005]rBA\u0002B]fD\u0001\"a\u000f\u0002\u001a\u0001\u0007\u0011QH\u0001\u0003M:\u0004rADA \u0003\u0007\n\u0019#C\u0002\u0002B=\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0007\u0003\t)\u0018.\u0003\u0003\u0002N\u0005\u001d#aB*qCJ\\W+\u0013\u0005\u0007w\u0006e\u0001\u0019\u0001?\t\u0011\u0005E\u0011\u0011\u0004a\u0001\u0003'Aq!!\u0016\u0001\t\u0003\t9&\u0001\u0003tSj,GCAA-!\rq\u00111L\u0005\u0004\u0003;z!\u0001\u0002'p]\u001eDq!!\u0019\u0001\t\u0013\t\u0019'\u0001\u0003uS6,W\u0003BA3\u0003W\"B!a\u001a\u0002xQ!\u0011\u0011NA7!\u0011\t)#a\u001b\u0005\u0011\u0005%\u0012q\fb\u0001\u0003WA\u0011\"a\u001c\u0002`\u0011\u0005\r!!\u001d\u0002\u0003\u0019\u0004RADA:\u0003SJ1!!\u001e\u0010\u0005!a$-\u001f8b[\u0016t\u0004\u0002CA=\u0003?\u0002\r!a\u001f\u0002\u0003Q\u0004B!! \u0002\u00066\u0011\u0011q\u0010\u0006\u0004a\u0006\u0005%bAAB\u0011\u0006A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\b\u0006}$!\u0002+j[\u0016\u0014\bbBAF\u0001\u0011%\u0011QR\u0001\u0015Y>\fG-\u00119qY&\u001c\u0017\r^5p]\u0016sGO]=\u0015\u000b=\u000by)!%\t\rm\fI\t1\u0001}\u0011!\t\t\"!#A\u0002\u0005M\u0001FBAE\u0003+\u000b)\u000bE\u0003\u000f\u0003/\u000bY*C\u0002\u0002\u001a>\u0011a\u0001\u001e5s_^\u001c\b\u0003BAO\u0003Ck!!a(\u000b\u0005E\u0002\u0017\u0002BAR\u0003?\u0013aCT8Tk\u000eDW\t\\3nK:$X\t_2faRLwN\\\u0019\u0007=q\f9+!52\u0013\r\nI+a,\u0002H\u0006EV\u0003BAV\u0003[+\u0012\u0001 \u0003\b\u0003SY\"\u0019AA\\\u0013\u0011\t\t,a-\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t)lD\u0001\u0007i\"\u0014xn^:\u0012\t\u00055\u0012\u0011\u0018\t\u0005\u0003w\u000b\tMD\u0002\u000f\u0003{K1!a0\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!a1\u0002F\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u007f{\u0011'C\u0012\u0002J\u0006-\u0017QZA[\u001d\rq\u00111Z\u0005\u0004\u0003k{\u0011'\u0002\u0012\u000f\u001f\u0005='!B:dC2\f\u0017g\u0001\u0014\u0002\u001c\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003qDq!a7\u0001\t\u0013\ti.\u0001\bsK\u001eL7\u000f^3s\r&dG/\u001a:\u0015\r\u0005}\u0017Q]Au!\rq\u0011\u0011]\u0005\u0004\u0003G|!\u0001B+oSRDq!a:\u0002Z\u0002\u0007A*A\u0002lKfD\u0001\"a;\u0002Z\u0002\u0007\u0011Q^\u0001\tY>\fG-\u001a3V\u0013B\u0019a$a<\n\u0007\u0005E(AA\u0006M_\u0006$W\rZ!qaVK\u0005bBA{\u0001\u0011\u0005\u0011q_\u0001\u000bS:4\u0018\r\\5eCR,G\u0003BAp\u0003sDq!a:\u0002t\u0002\u0007A\nC\u0005\u0002~\u0002\t\n\u0011\"\u0001\u0002\u0000\u0006iq-\u001a;%I\u00164\u0017-\u001e7uII*\"A!\u0001+\t\u0005M!1A\u0016\u0003\u0005\u000b\u0001BAa\u0002\u0003\u00125\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!A\u0005v]\u000eDWmY6fI*\u0019!qB\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0014\t%!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ApplicationCache
implements Logging {
    private final ApplicationCacheOperations operations;
    private final int retainedApplications;
    private final Clock clock;
    private final CacheLoader<CacheKey, CacheEntry> appLoader;
    private final RemovalListener<CacheKey, CacheEntry> removalListener;
    private final LoadingCache<CacheKey, CacheEntry> appCache;
    private final CacheMetrics metrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ApplicationCacheOperations operations() {
        return this.operations;
    }

    public int retainedApplications() {
        return this.retainedApplications;
    }

    public Clock clock() {
        return this.clock;
    }

    private CacheLoader<CacheKey, CacheEntry> appLoader() {
        return this.appLoader;
    }

    private RemovalListener<CacheKey, CacheEntry> removalListener() {
        return this.removalListener;
    }

    private LoadingCache<CacheKey, CacheEntry> appCache() {
        return this.appCache;
    }

    public CacheMetrics metrics() {
        return this.metrics;
    }

    public CacheEntry get(String appId, Option<String> attemptId) {
        CacheEntry cacheEntry;
        try {
            cacheEntry = (CacheEntry)this.appCache().get((Object)new CacheKey(appId, attemptId));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ExecutionException ? true : throwable2 instanceof UncheckedExecutionException;
            if (bl) {
                throw (Throwable)Option$.MODULE$.apply((Object)throwable2.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> throwable2);
            }
            throw throwable;
        }
        return cacheEntry;
    }

    public Option<String> get$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withSparkUI(String appId, Option<String> attemptId, Function1<SparkUI, T> fn) {
        CacheEntry entry = this.get(appId, attemptId);
        entry.loadedUI().lock().readLock().lock();
        try {
            while (!entry.loadedUI().valid()) {
                entry.loadedUI().lock().readLock().unlock();
                entry = null;
                try {
                    this.invalidate(new CacheKey(appId, attemptId));
                    entry = this.get(appId, attemptId);
                    this.metrics().loadCount().inc();
                }
                finally {
                    if (entry == null) continue;
                    entry.loadedUI().lock().readLock().lock();
                }
            }
            return (T)fn.apply((Object)entry.loadedUI().ui());
        }
        finally {
            if (entry != null) {
                entry.loadedUI().lock().readLock().unlock();
            }
        }
    }

    public long size() {
        return this.appCache().size();
    }

    private <T> T time(Timer t, Function0<T> f) {
        Object object;
        try (Timer.Context timeCtx = t.time();){
            object = f.apply();
        }
        return (T)object;
    }

    public CacheEntry org$apache$spark$deploy$history$ApplicationCache$$loadApplicationEntry(String appId, Option<String> attemptId) throws NoSuchElementException {
        CacheEntry cacheEntry;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Loading application Entry ").append(appId).append("/").append(attemptId).toString());
        this.metrics().loadCount().inc();
        LoadedAppUI loadedUI = (LoadedAppUI)this.time(this.metrics().loadTimer(), (Function0 & Serializable & scala.Serializable)() -> {
            this.metrics().lookupCount().inc();
            Option<LoadedAppUI> option = this.operations().getAppUI(appId, attemptId);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    this.metrics().lookupFailureCount().inc();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("Failed to load application attempt ").append(appId).append("/").append(attemptId).toString());
                    throw new NoSuchElementException(new java.lang.StringBuilder(37).append("no application with application Id '").append(appId).append("'").append(attemptId.map((Function1 & Serializable & scala.Serializable)id -> new java.lang.StringBuilder(13).append(" attemptId '").append((String)id).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> " and no attempt Id")).toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            LoadedAppUI loadedUI = (LoadedAppUI)some.value();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Loaded application ").append(appId).append("/").append(attemptId).toString());
            LoadedAppUI loadedAppUI = loadedUI;
            return loadedAppUI;
        });
        try {
            boolean completed = loadedUI.ui().getApplicationInfoList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ApplicationCache.$anonfun$loadApplicationEntry$7(x$1)));
            if (!completed) {
                this.registerFilter(new CacheKey(appId, attemptId), loadedUI);
            }
            this.operations().attachSparkUI(appId, attemptId, loadedUI.ui(), completed);
            cacheEntry = new CacheEntry(loadedUI, completed);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(41).append("Failed to initialize application UI for ").append(appId).append("/").append(attemptId).toString(), e);
            this.operations().detachSparkUI(appId, attemptId, loadedUI.ui());
            throw e;
        }
        return cacheEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(new java.lang.StringBuilder(17).append("ApplicationCache(").append(new java.lang.StringBuilder(24).append(" retainedApplications= ").append(this.retainedApplications()).append(")").toString()).toString());
        sb.append(new java.lang.StringBuilder(8).append("; time= ").append(this.clock().getTimeMillis()).toString());
        sb.append(new java.lang.StringBuilder(16).append("; entry count= ").append(this.appCache().size()).append("\n").toString());
        sb.append("----\n");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.appCache().asMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CacheKey key = (CacheKey)tuple2._1();
            CacheEntry entry = (CacheEntry)tuple2._2();
            StringBuilder stringBuilder = sb.append(new java.lang.StringBuilder(7).append("  ").append(key).append(" -> ").append(entry).append("\n").toString());
            return stringBuilder;
        });
        sb.append("----\n");
        sb.append((Object)this.metrics());
        sb.append("----\n");
        return sb.toString();
    }

    private void registerFilter(CacheKey key, LoadedAppUI loadedUI) {
        Predef$.MODULE$.require(loadedUI != null);
        EnumSet<DispatcherType> enumDispatcher = EnumSet.of(DispatcherType.ASYNC, DispatcherType.REQUEST);
        ApplicationCacheCheckFilter filter = new ApplicationCacheCheckFilter(key, loadedUI, this);
        FilterHolder holder = new FilterHolder(filter);
        Predef$.MODULE$.require(loadedUI.ui().getHandlers() != null, (Function0 & Serializable & scala.Serializable)() -> "null handlers");
        loadedUI.ui().getHandlers().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.addFilter(holder, "/*", (EnumSet<DispatcherType>)enumDispatcher);
            return BoxedUnit.UNIT;
        });
    }

    public void invalidate(CacheKey key) {
        this.appCache().invalidate((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$loadApplicationEntry$7(ApplicationInfo x$1) {
        return ((ApplicationAttemptInfo)x$1.attempts().last()).completed();
    }

    public ApplicationCache(ApplicationCacheOperations operations, int retainedApplications, Clock clock) {
        this.operations = operations;
        this.retainedApplications = retainedApplications;
        this.clock = clock;
        Logging.$init$(this);
        this.appLoader = new CacheLoader<CacheKey, CacheEntry>(this){
            private final /* synthetic */ ApplicationCache $outer;

            public CacheEntry load(CacheKey key) {
                return this.$outer.org$apache$spark$deploy$history$ApplicationCache$$loadApplicationEntry(key.appId(), key.attemptId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.removalListener = new RemovalListener<CacheKey, CacheEntry>(this){
            private final /* synthetic */ ApplicationCache $outer;

            public void onRemoval(RemovalNotification<CacheKey, CacheEntry> rm) {
                this.$outer.metrics().evictionCount().inc();
                CacheKey key = (CacheKey)rm.getKey();
                this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Evicting entry ").append(key).toString());
                this.$outer.operations().detachSparkUI(key.appId(), key.attemptId(), ((CacheEntry)rm.getValue()).loadedUI().ui());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onRemoval$1(org.apache.spark.deploy.history.CacheKey )}, serializedLambda);
            }
        };
        this.appCache = CacheBuilder.newBuilder().maximumSize((long)retainedApplications).removalListener(this.removalListener()).build(this.appLoader());
        this.metrics = new CacheMetrics("history.cache");
    }
}

