/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.r.BufferedStreamThread;
import org.apache.spark.api.r.RAuthHelper;
import org.apache.spark.api.r.RRunnerModes$;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.api.r.SparkRDefaults$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class RRunner$ {
    public static RRunner$ MODULE$;
    private RAuthHelper org$apache$spark$api$r$RRunner$$authHelper;
    private BufferedStreamThread errThread;
    private DataOutputStream daemonChannel;
    private volatile boolean bitmap$0;

    static {
        new RRunner$();
    }

    public <U> int $lessinit$greater$default$6() {
        return -1;
    }

    public <U> boolean $lessinit$greater$default$7() {
        return false;
    }

    public <U> String[] $lessinit$greater$default$8() {
        return null;
    }

    public <U> int $lessinit$greater$default$9() {
        return RRunnerModes$.MODULE$.RDD();
    }

    private RAuthHelper authHelper$lzycompute() {
        RRunner$ rRunner$ = this;
        synchronized (rRunner$) {
            if (!this.bitmap$0) {
                SparkConf conf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SparkConf());
                this.org$apache$spark$api$r$RRunner$$authHelper = new RAuthHelper(conf);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$api$r$RRunner$$authHelper;
    }

    public RAuthHelper org$apache$spark$api$r$RRunner$$authHelper() {
        return !this.bitmap$0 ? this.authHelper$lzycompute() : this.org$apache$spark$api$r$RRunner$$authHelper;
    }

    /*
     * WARNING - void declaration
     */
    private BufferedStreamThread startStdoutThread(Process proc) {
        void var3_3;
        int BUFFER_SIZE = 100;
        BufferedStreamThread thread = new BufferedStreamThread(proc.getInputStream(), "stdout reader for R", BUFFER_SIZE);
        thread.setDaemon(true);
        thread.start();
        return var3_3;
    }

    private BufferedStreamThread createRProcess(int port, String script) {
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        String rCommand = sparkConf.get("spark.sparkr.r.command", "Rscript");
        rCommand = sparkConf.get("spark.r.command", rCommand);
        int rConnectionTimeout = sparkConf.getInt("spark.r.backendConnectionTimeout", SparkRDefaults$.MODULE$.DEFAULT_CONNECTION_TIMEOUT());
        String rOptions = "--vanilla";
        Seq<String> rLibDir = RUtils$.MODULE$.sparkRPackagePath(false);
        String rExecScript = new StringBuilder(15).append((String)rLibDir.apply(0)).append("/SparkR/worker/").append(script).toString();
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{rCommand, rOptions, rExecScript}));
        pb.environment().put("R_TESTS", "");
        pb.environment().put("SPARKR_RLIBDIR", rLibDir.mkString(","));
        pb.environment().put("SPARKR_WORKER_PORT", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        pb.environment().put("SPARKR_BACKEND_CONNECTION_TIMEOUT", ((Object)BoxesRunTime.boxToInteger((int)rConnectionTimeout)).toString());
        pb.environment().put("SPARKR_SPARKFILES_ROOT_DIR", SparkFiles$.MODULE$.getRootDirectory());
        pb.environment().put("SPARKR_IS_RUNNING_ON_WORKER", "TRUE");
        pb.environment().put("SPARKR_WORKER_SECRET", this.org$apache$spark$api$r$RRunner$$authHelper().secret());
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedStreamThread errThread = this.startStdoutThread(proc);
        return errThread;
    }

    public BufferedStreamThread createRWorker(int port) {
        BufferedStreamThread bufferedStreamThread;
        boolean useDaemon = SparkEnv$.MODULE$.get().conf().getBoolean("spark.sparkr.use.daemon", true);
        if (!Utils$.MODULE$.isWindows() && useDaemon) {
            RRunner$ rRunner$ = this;
            synchronized (rRunner$) {
                if (this.daemonChannel == null) {
                    ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByName("localhost"));
                    int daemonPort = serverSocket.getLocalPort();
                    this.errThread = this.createRProcess(daemonPort, "daemon.R");
                    serverSocket.setSoTimeout(10000);
                    Socket sock = serverSocket.accept();
                    try {
                        this.org$apache$spark$api$r$RRunner$$authHelper().authClient(sock);
                        this.daemonChannel = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
                    }
                    finally {
                        serverSocket.close();
                    }
                }
                this.liftedTree1$1(port);
                BufferedStreamThread bufferedStreamThread2 = this.errThread;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                bufferedStreamThread = bufferedStreamThread2;
            }
        }
        bufferedStreamThread = this.createRProcess(port, "worker.R");
        return bufferedStreamThread;
    }

    private final void liftedTree1$1(int port$1) {
        try {
            this.daemonChannel.writeInt(port$1);
            this.daemonChannel.flush();
        }
        catch (IOException e) {
            this.daemonChannel.close();
            this.daemonChannel = null;
            this.errThread = null;
            throw e;
        }
    }

    private RRunner$() {
        MODULE$ = this;
    }
}

