/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.PythonWorkerFactory$;
import org.apache.spark.internal.Logging;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.WeakHashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u0001\u0003\u0001\u0019a!a\u0005)zi\"|gnV8sW\u0016\u0014h)Y2u_JL(BA\u0002\u0005\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u0003)\u0001\u0018\u0010\u001e5p]\u0016CXmY\u0002\u0001!\tiBE\u0004\u0002\u001fEA\u0011qdD\u0007\u0002A)\u0011\u0011eG\u0001\u0007yI|w\u000e\u001e \n\u0005\rz\u0011A\u0002)sK\u0012,g-\u0003\u0002&M\t11\u000b\u001e:j]\u001eT!aI\b\t\u0011!\u0002!\u0011!Q\u0001\n%\nq!\u001a8w-\u0006\u00148\u000f\u0005\u0003\u001eUqa\u0012BA\u0016'\u0005\ri\u0015\r\u001d\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\n$\u0007\u0005\u00021\u00015\t!\u0001C\u0003\u001bY\u0001\u0007A\u0004C\u0003)Y\u0001\u0007\u0011\u0006C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u0013U\u001cX\rR1f[>tW#\u0001\u001c\u0011\u000599\u0014B\u0001\u001d\u0010\u0005\u001d\u0011un\u001c7fC:DaA\u000f\u0001!\u0002\u00131\u0014AC;tK\u0012\u000bW-\\8oA!9A\b\u0001b\u0001\n\u0003i\u0014\u0001\u00043bK6|g.T8ek2,W#\u0001\u000f\t\r}\u0002\u0001\u0015!\u0003\u001d\u00035!\u0017-Z7p]6{G-\u001e7fA!9\u0011\t\u0001b\u0001\n\u0003i\u0014\u0001D<pe.,'/T8ek2,\u0007BB\"\u0001A\u0003%A$A\u0007x_J\\WM]'pIVdW\r\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0003)\tW\u000f\u001e5IK2\u0004XM]\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JB\u0001\tg\u0016\u001cWO]5us&\u0011A*\u0013\u0002\u0011'>\u001c7.\u001a;BkRD\u0007*\u001a7qKJDaA\u0014\u0001!\u0002\u00139\u0015aC1vi\"DU\r\u001c9fe\u0002Bq\u0001\u0015\u0001A\u0002\u0013\u0005\u0011+\u0001\u0004eC\u0016lwN\\\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&a\u0002)s_\u000e,7o\u001d\u0005\b7\u0002\u0001\r\u0011\"\u0001]\u0003)!\u0017-Z7p]~#S-\u001d\u000b\u0003;\u0002\u0004\"A\u00040\n\u0005}{!\u0001B+oSRDq!\u0019.\u0002\u0002\u0003\u0007!+A\u0002yIEBaa\u0019\u0001!B\u0013\u0011\u0016a\u00023bK6|g\u000e\t\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0003)!\u0017-Z7p]\"{7\u000f^\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!NV\u0001\u0004]\u0016$\u0018B\u00017j\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\t\r9\u0004\u0001\u0015!\u0003h\u0003-!\u0017-Z7p]\"{7\u000f\u001e\u0011\t\u000fA\u0004\u0001\u0019!C\u0001c\u0006QA-Y3n_:\u0004vN\u001d;\u0016\u0003I\u0004\"AD:\n\u0005Q|!aA%oi\"9a\u000f\u0001a\u0001\n\u00039\u0018A\u00043bK6|g\u000eU8si~#S-\u001d\u000b\u0003;bDq!Y;\u0002\u0002\u0003\u0007!\u000f\u0003\u0004{\u0001\u0001\u0006KA]\u0001\fI\u0006,Wn\u001c8Q_J$\b\u0005C\u0004}\u0001\t\u0007I\u0011A?\u0002\u001b\u0011\fW-\\8o/>\u00148.\u001a:t+\u0005q\bCB@\u0002\n\u00055!/\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u001diW\u000f^1cY\u0016T1!a\u0002\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\t\tAA\u0006XK\u0006\\\u0007*Y:i\u001b\u0006\u0004\bc\u00015\u0002\u0010%\u0019\u0011\u0011C5\u0003\rM{7m[3u\u0011\u001d\t)\u0002\u0001Q\u0001\ny\fa\u0002Z1f[>twk\u001c:lKJ\u001c\b\u0005C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u001c\u0005Y\u0011\u000e\u001a7f/>\u00148.\u001a:t+\t\ti\u0002E\u0003\u0000\u0003?\ti!\u0003\u0003\u0002\"\u0005\u0005!!B)vKV,\u0007\u0002CA\u0013\u0001\u0001\u0006I!!\b\u0002\u0019%$G.Z,pe.,'o\u001d\u0011\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0012\u0001\u00047bgR\f5\r^5wSRLXCAA\u0017!\rq\u0011qF\u0005\u0004\u0003cy!\u0001\u0002'p]\u001eD\u0011\"!\u000e\u0001\u0001\u0004%\t!a\u000e\u0002!1\f7\u000f^!di&4\u0018\u000e^=`I\u0015\fHcA/\u0002:!I\u0011-a\r\u0002\u0002\u0003\u0007\u0011Q\u0006\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002.\u0005iA.Y:u\u0003\u000e$\u0018N^5us\u0002B\u0011\"!\u0011\u0001\u0001\u0004%\t!a\u0011\u0002\u001bMLW\u000e\u001d7f/>\u00148.\u001a:t+\t\t)\u0005\u0005\u0004\u0000\u0003\u0013\tiA\u0015\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0001\u0003\u0017\n\u0011c]5na2,wk\u001c:lKJ\u001cx\fJ3r)\ri\u0016Q\n\u0005\nC\u0006\u001d\u0013\u0011!a\u0001\u0003\u000bB\u0001\"!\u0015\u0001A\u0003&\u0011QI\u0001\u000fg&l\u0007\u000f\\3X_J\\WM]:!\u0011!\t)\u0006\u0001b\u0001\n\u0003i\u0014A\u00039zi\"|g\u000eU1uQ\"9\u0011\u0011\f\u0001!\u0002\u0013a\u0012a\u00039zi\"|g\u000eU1uQ\u0002Bq!!\u0018\u0001\t\u0003\ty&\u0001\u0004de\u0016\fG/\u001a\u000b\u0003\u0003\u001bAq!a\u0019\u0001\t\u0013\ty&A\nde\u0016\fG/\u001a+ie>,x\r\u001b#bK6|g\u000eC\u0004\u0002h\u0001!I!a\u0018\u0002%\r\u0014X-\u0019;f'&l\u0007\u000f\\3X_J\\WM\u001d\u0005\b\u0003W\u0002A\u0011BA7\u0003-\u0019H/\u0019:u\t\u0006,Wn\u001c8\u0015\u0003uCq!!\u001d\u0001\t\u0013\t\u0019(A\fsK\u0012L'/Z2u'R\u0014X-Y7t)>\u001cF\u000fZ3seR)Q,!\u001e\u0002\u0006\"A\u0011qOA8\u0001\u0004\tI(\u0001\u0004ti\u0012|W\u000f\u001e\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011q\u0010,\u0002\u0005%|\u0017\u0002BAB\u0003{\u00121\"\u00138qkR\u001cFO]3b[\"A\u0011qQA8\u0001\u0004\tI(\u0001\u0004ti\u0012,'O\u001d\u0004\u0007\u0003\u0017\u0003A!!$\u0003\u001b5{g.\u001b;peRC'/Z1e'\u0011\tI)a$\u0011\u0007M\u000b\t*C\u0002\u0002\u0014R\u0013a\u0001\u00165sK\u0006$\u0007bB\u0017\u0002\n\u0012\u0005\u0011q\u0013\u000b\u0003\u00033\u0003B!a'\u0002\n6\t\u0001\u0001\u0003\u0005\u0002 \u0006%E\u0011IA7\u0003\r\u0011XO\u001c\u0005\b\u0003G\u0003A\u0011BA7\u0003I\u0019G.Z1okBLE\r\\3X_J\\WM]:\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002n\u0005Q1\u000f^8q\t\u0006,Wn\u001c8\t\u000f\u0005-\u0006\u0001\"\u0001\u0002n\u0005!1\u000f^8q\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u000b!b\u001d;pa^{'o[3s)\ri\u00161\u0017\u0005\t\u0003k\u000bi\u000b1\u0001\u0002\u000e\u00051qo\u001c:lKJDq!!/\u0001\t\u0003\tY,A\u0007sK2,\u0017m]3X_J\\WM\u001d\u000b\u0004;\u0006u\u0006\u0002CA[\u0003o\u0003\r!!\u0004\b\u000f\u0005\u0005'\u0001#\u0003\u0002D\u0006\u0019\u0002+\u001f;i_:<vN]6fe\u001a\u000b7\r^8ssB\u0019\u0001'!2\u0007\r\u0005\u0011\u0001\u0012BAd'\r\t)-\u0004\u0005\b[\u0005\u0015G\u0011AAf)\t\t\u0019\rC\u0005\u0002P\u0006\u0015'\u0019!C\u0001c\u00069\u0002KU(D\u000bN\u001bvlV!J)~#\u0016*T#P+R{Vj\u0015\u0005\t\u0003'\f)\r)A\u0005e\u0006A\u0002KU(D\u000bN\u001bvlV!J)~#\u0016*T#P+R{Vj\u0015\u0011\t\u0013\u0005]\u0017Q\u0019b\u0001\n\u0003\t\u0018AF%E\u0019\u0016{vk\u0014*L\u000bJ{F+S'F\u001fV#v,T*\t\u0011\u0005m\u0017Q\u0019Q\u0001\nI\fq#\u0013#M\u000b~;vJU&F%~#\u0016*T#P+R{Vj\u0015\u0011")
public class PythonWorkerFactory
implements Logging {
    public final String org$apache$spark$api$python$PythonWorkerFactory$$pythonExec;
    private final scala.collection.immutable.Map<String, String> envVars;
    private final boolean useDaemon;
    private final String daemonModule;
    private final String workerModule;
    private final SocketAuthHelper authHelper;
    private Process daemon;
    private final InetAddress daemonHost;
    private int daemonPort;
    private final WeakHashMap<Socket, Object> daemonWorkers;
    private final Queue<Socket> idleWorkers;
    private long lastActivity;
    private WeakHashMap<Socket, Process> simpleWorkers;
    private final String pythonPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int IDLE_WORKER_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_MS();
    }

    public static int PROCESS_WAIT_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean useDaemon() {
        return this.useDaemon;
    }

    public String daemonModule() {
        return this.daemonModule;
    }

    public String workerModule() {
        return this.workerModule;
    }

    private SocketAuthHelper authHelper() {
        return this.authHelper;
    }

    public Process daemon() {
        return this.daemon;
    }

    public void daemon_$eq(Process x$1) {
        this.daemon = x$1;
    }

    public InetAddress daemonHost() {
        return this.daemonHost;
    }

    public int daemonPort() {
        return this.daemonPort;
    }

    public void daemonPort_$eq(int x$1) {
        this.daemonPort = x$1;
    }

    public WeakHashMap<Socket, Object> daemonWorkers() {
        return this.daemonWorkers;
    }

    public Queue<Socket> idleWorkers() {
        return this.idleWorkers;
    }

    public long lastActivity() {
        return this.lastActivity;
    }

    public void lastActivity_$eq(long x$1) {
        this.lastActivity = x$1;
    }

    public WeakHashMap<Socket, Process> simpleWorkers() {
        return this.simpleWorkers;
    }

    public void simpleWorkers_$eq(WeakHashMap<Socket, Process> x$1) {
        this.simpleWorkers = x$1;
    }

    public String pythonPath() {
        return this.pythonPath;
    }

    public Socket create() {
        Socket socket;
        if (this.useDaemon()) {
            block7: {
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    Socket socket2;
                    block6: {
                        if (this.idleWorkers().size() > 0) {
                            socket2 = (Socket)this.idleWorkers().dequeue();
                            break block6;
                        }
                        break block7;
                    }
                    return socket2;
                }
            }
            socket = this.createThroughDaemon();
        } else {
            socket = this.createSimpleWorker();
        }
        return socket;
    }

    private Socket createThroughDaemon() {
        Socket socket;
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            this.startDaemon();
            socket = this.liftedTree1$1();
        }
        return socket;
    }

    private Socket createSimpleWorker() {
        Socket socket;
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket(0, 1, InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte())));
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.workerModule()}));
            java.util.Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            workerEnv.put("PYTHON_WORKER_FACTORY_PORT", ((Object)BoxesRunTime.boxToInteger((int)serverSocket.getLocalPort())).toString());
            workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            Process worker = pb.start();
            this.redirectStreamsToStderr(worker.getInputStream(), worker.getErrorStream());
            serverSocket.setSoTimeout(10000);
            try {
                Socket socket2 = serverSocket.accept();
                this.authHelper().authClient(socket2);
                this.simpleWorkers().put((Object)socket2, (Object)worker);
                socket = socket2;
            }
            catch (Exception e) {
                throw new SparkException("Python worker failed to connect back.", e);
            }
        }
        return socket;
    }

    private synchronized void startDaemon() {
        if (this.daemon() != null) {
            return;
        }
        try {
            List<Object> command = Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.daemonModule()});
            ProcessBuilder pb = new ProcessBuilder(command);
            java.util.Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            this.daemon_$eq(pb.start());
            DataInputStream in = new DataInputStream(this.daemon().getInputStream());
            try {
                this.daemonPort_$eq(in.readInt());
            }
            catch (EOFException eOFException) {
                throw new SparkException(new StringBuilder(27).append("No port number in ").append(this.daemonModule()).append("'s stdout").toString());
            }
            if (this.daemonPort() < 1 || this.daemonPort() > 65535) {
                String arg$macro$1 = this.daemonModule();
                Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)this.daemonPort());
                int arg$macro$3 = this.daemonPort();
                String arg$macro$4 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala()).mkString(" ");
                String arg$macro$5 = this.pythonPath();
                String exceptionMessage = new StringOps("\n            |Bad data in %s's standard output. Invalid port number:\n            |  %s (0x%08x)\n            |Python command to execute the daemon was:\n            |  %s\n            |Check that you don't have any unexpected modules or libraries in\n            |your PYTHONPATH:\n            |  %s\n            |Also, check if you have a sitecustomize.py module in your python path,\n            |or in your python installation, that is printing to standard output").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToInteger((int)arg$macro$3), arg$macro$4, arg$macro$5}));
                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(exceptionMessage)).stripMargin());
            }
            this.redirectStreamsToStderr(in, this.daemon().getErrorStream());
        }
        catch (Exception e) {
            String stderr = (String)Option$.MODULE$.apply((Object)this.daemon()).flatMap((Function1 & Serializable & scala.Serializable)d -> Utils$.MODULE$.getStderr((Process)d, PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.stopDaemon();
            String string = stderr;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String formattedStderr = stderr.replace("\n", "\n  ");
                String errorMessage = new StringBuilder(124).append("\n              |Error from python worker:\n              |  ").append(formattedStderr).append("\n              |PYTHONPATH was:\n              |  ").append(this.pythonPath()).append("\n              |").append(e).toString();
                SparkException wrappedException = new SparkException(new StringOps(Predef$.MODULE$.augmentString(errorMessage)).stripMargin());
                wrappedException.setStackTrace(e.getStackTrace());
                throw wrappedException;
            }
            throw e;
        }
    }

    private void redirectStreamsToStderr(InputStream stdout, InputStream stderr) {
        try {
            new RedirectThread(stdout, System.err, new StringBuilder(18).append("stdout reader for ").append(this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString(), RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            new RedirectThread(stderr, System.err, new StringBuilder(18).append("stderr reader for ").append(this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString(), RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in redirecting streams", e);
        }
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers() {
        while (this.idleWorkers().nonEmpty()) {
            Socket worker = (Socket)this.idleWorkers().dequeue();
            try {
                worker.close();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close worker socket", e);
            }
        }
    }

    private void stopDaemon() {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            Map map;
            if (this.useDaemon()) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                if (this.daemon() != null) {
                    this.daemon().destroy();
                }
                this.daemon_$eq(null);
                this.daemonPort_$eq(0);
                map = BoxedUnit.UNIT;
            } else {
                map = this.simpleWorkers().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public void stop() {
        this.stopDaemon();
    }

    public void stopWorker(Socket worker) {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            if (this.useDaemon()) {
                if (this.daemon() != null) {
                    this.daemonWorkers().get((Object)worker).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
                        DataOutputStream output = new DataOutputStream(this.daemon().getOutputStream());
                        output.writeInt(pid);
                        output.flush();
                        this.daemon().getOutputStream().flush();
                    });
                }
            } else {
                this.simpleWorkers().get((Object)worker).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
        worker.close();
    }

    public void releaseWorker(Socket worker) {
        if (this.useDaemon()) {
            PythonWorkerFactory pythonWorkerFactory = this;
            synchronized (pythonWorkerFactory) {
                this.lastActivity_$eq(System.currentTimeMillis());
                this.idleWorkers().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Socket[]{worker}));
            }
        } else {
            try {
                worker.close();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close worker socket", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Socket createSocket$1() {
        void var1_1;
        Socket socket = new Socket(this.daemonHost(), this.daemonPort());
        int pid = new DataInputStream(socket.getInputStream()).readInt();
        if (pid < 0) {
            throw new IllegalStateException(new StringBuilder(48).append("Python daemon failed to launch worker with code ").append(pid).toString());
        }
        this.authHelper().authToServer(socket);
        this.daemonWorkers().put((Object)socket, (Object)BoxesRunTime.boxToInteger((int)pid));
        return var1_1;
    }

    private final Socket liftedTree1$1() {
        Socket socket;
        try {
            socket = this.createSocket$1();
        }
        catch (SocketException exc) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to open socket to Python daemon:", exc);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Assuming that daemon unexpectedly quit, attempting to restart");
            this.stopDaemon();
            this.startDaemon();
            socket = this.createSocket$1();
        }
        return socket;
    }

    public PythonWorkerFactory(String pythonExec, scala.collection.immutable.Map<String, String> envVars) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec = pythonExec;
        this.envVars = envVars;
        Logging.$init$(this);
        boolean useDaemonEnabled = SparkEnv$.MODULE$.get().conf().getBoolean("spark.python.use.daemon", true);
        this.useDaemon = !System.getProperty("os.name").startsWith("Windows") && useDaemonEnabled;
        this.daemonModule = (String)SparkEnv$.MODULE$.get().conf().getOption("spark.python.daemon.module").map((Function1 & Serializable & scala.Serializable)value -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("Python daemon module in PySpark is set to [").append((String)value).append("] in 'spark.python.daemon.module', ").append("using this to start the daemon up. Note that this configuration only has an effect when ").append("'spark.python.use.daemon' is enabled and the platform is not Windows.").toString());
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "pyspark.daemon");
        this.workerModule = (String)SparkEnv$.MODULE$.get().conf().getOption("spark.python.worker.module").map((Function1 & Serializable & scala.Serializable)value -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("Python worker module in PySpark is set to [").append((String)value).append("] in 'spark.python.worker.module', ").append("using this to start the worker up. Note that this configuration only has an effect when ").append("'spark.python.use.daemon' is disabled or the platform is Windows.").toString());
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "pyspark.worker");
        this.authHelper = new SocketAuthHelper(SparkEnv$.MODULE$.get().conf());
        this.daemon = null;
        this.daemonHost = InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte()));
        this.daemonPort = 0;
        this.daemonWorkers = new WeakHashMap();
        this.idleWorkers = new Queue();
        this.lastActivity = 0L;
        new MonitorThread().start();
        this.simpleWorkers = new WeakHashMap();
        this.pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{PythonUtils$.MODULE$.sparkPythonPath(), (String)envVars.getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> ""), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> "")}));
    }

    public class MonitorThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                MonitorThread monitorThread = this;
                synchronized (monitorThread) {
                    if (this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().lastActivity() + (long)PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_MS() < System.currentTimeMillis()) {
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().lastActivity_$eq(System.currentTimeMillis());
                    }
                }
                Thread.sleep(10000L);
            }
        }

        public /* synthetic */ PythonWorkerFactory org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer() {
            return PythonWorkerFactory.this;
        }

        public MonitorThread() {
            if (PythonWorkerFactory.this == null) {
                throw null;
            }
            super(new StringBuilder(24).append("Idle Worker Monitor for ").append(PythonWorkerFactory.this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString());
            this.setDaemon(true);
        }
    }
}

