/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.net.URL;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SparkContext$
implements Logging {
    public static SparkContext$ MODULE$;
    private final Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    private final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private Option<SparkContext> contextBeingConstructed;
    private final String SPARK_JOB_DESCRIPTION;
    private final String SPARK_JOB_GROUP_ID;
    private final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private final String RDD_SCOPE_KEY;
    private final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private final String DRIVER_IDENTIFIER;
    private final String LEGACY_DRIVER_IDENTIFIER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkContext$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS() {
        return this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return this.SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return this.org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return this.contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        this.contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get()).filter((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$1(sc, x$35))).foreach((Function1 & Serializable & scala.Serializable)ctx -> {
                SparkContext$.$anonfun$assertNoOtherContextIsRunning$2(allowMultipleContexts, ctx);
                return BoxedUnit.UNIT;
            });
            this.contextBeingConstructed().filter((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$4(sc, x$36))).foreach((Function1 & Serializable & scala.Serializable)otherContext -> {
                SparkContext$.$anonfun$assertNoOtherContextIsRunning$5(otherContext);
                return BoxedUnit.UNIT;
            });
        }
    }

    public SparkContext getOrCreate(SparkConf config2) {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config2), false);
            } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config2.getAll())).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using an existing SparkContext; some configuration may not take effect.");
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public SparkContext getOrCreate() {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(), false);
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public Option<SparkContext> getActive() {
        Option option;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get());
        }
        return option;
    }

    public void markPartiallyConstructed(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc, allowMultipleContexts);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
        }
    }

    public void setActiveContext(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc, allowMultipleContexts);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return this.SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return this.SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return this.SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String RDD_SCOPE_KEY() {
        return this.RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return this.RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return this.DRIVER_IDENTIFIER;
    }

    public String LEGACY_DRIVER_IDENTIFIER() {
        return this.LEGACY_DRIVER_IDENTIFIER;
    }

    private <T extends Writable> ArrayWritable arrayToArrayWritable(Traversable<T> arr, ClassTag<T> evidence$19) {
        return new ArrayWritable(package$.MODULE$.classTag(evidence$19).runtimeClass(), (Writable[])((TraversableOnce)arr.map((Function1 & Serializable & scala.Serializable)x -> SparkContext$.anyToWritable$1(x), Traversable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Writable.class)));
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder(7).append("/").append(cls.getName().replace('.', '/')).append(".class").toString());
        return uri != null ? ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33))) : None$.MODULE$) : None$.MODULE$;
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome != null ? res.setSparkHome(sparkHome) : BoxedUnit.UNIT;
        Object object2 = jars != null && !jars.isEmpty() ? res.setJars(jars) : BoxedUnit.UNIT;
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        return this.numDriverCores(master, null);
    }

    public int numDriverCores(String master, SparkConf conf) {
        int n;
        String string = master;
        if ("local".equals(string)) {
            n = 1;
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                n = SparkContext$.convertToInt$1(threads);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    n = SparkContext$.convertToInt$1(threads);
                } else {
                    n = "yarn".equals(string) ? (conf != null && conf.getOption("spark.submit.deployMode").contains((Object)"cluster") ? conf.getInt("spark.driver.cores", 0) : 0) : 0;
                }
            }
        }
        return n;
    }

    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master, String deployMode) {
        Tuple2 tuple2;
        int MAX_LOCAL_TASK_FAILURES = 1;
        String string = master;
        if ("local".equals(string)) {
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
            LocalSchedulerBackend backend2 = new LocalSchedulerBackend(sc.getConf(), scheduler, 1);
            scheduler.initialize(backend2);
            tuple2 = new Tuple2((Object)backend2, (Object)scheduler);
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                int threadCount;
                String threads;
                String string2 = threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                String string3 = "*";
                int n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? SparkContext$.localCpuCount$1() : (threadCount = new StringOps(Predef$.MODULE$.augmentString(threads)).toInt());
                if (threadCount <= 0) {
                    throw new SparkException(new StringBuilder(34).append("Asked to run locally with ").append(threadCount).append(" threads").toString());
                }
                TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
                LocalSchedulerBackend backend3 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                scheduler.initialize(backend3);
                tuple2 = new Tuple2((Object)backend3, (Object)scheduler);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String maxFailures = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    String string4 = threads;
                    String string5 = "*";
                    int threadCount = !(string4 != null ? !string4.equals(string5) : string5 != null) ? SparkContext$.localCpuCount$2() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
                    TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, new StringOps(Predef$.MODULE$.augmentString(maxFailures)).toInt(), true);
                    LocalSchedulerBackend backend4 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                    scheduler.initialize(backend4);
                    tuple2 = new Tuple2((Object)backend4, (Object)scheduler);
                } else {
                    Option option3 = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((CharSequence)string);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                        String sparkUrl = (String)((LinearSeqOptimized)option3.get()).apply(0);
                        TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                        String[] masterUrls = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(","))).map((Function1 & Serializable & scala.Serializable)x$38 -> new StringBuilder(8).append("spark://").append((String)x$38).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        StandaloneSchedulerBackend backend5 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                        scheduler.initialize(backend5);
                        tuple2 = new Tuple2((Object)backend5, (Object)scheduler);
                    } else {
                        Option option4 = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((CharSequence)string);
                        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(3) == 0) {
                            String numSlaves = (String)((LinearSeqOptimized)option4.get()).apply(0);
                            String coresPerSlave = (String)((LinearSeqOptimized)option4.get()).apply(1);
                            String memoryPerSlave = (String)((LinearSeqOptimized)option4.get()).apply(2);
                            int memoryPerSlaveInt = new StringOps(Predef$.MODULE$.augmentString(memoryPerSlave)).toInt();
                            if (sc.executorMemory() > memoryPerSlaveInt) {
                                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MB RAM / worker but requested %d MB/worker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerSlaveInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
                            }
                            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                            LocalSparkCluster localCluster = new LocalSparkCluster(new StringOps(Predef$.MODULE$.augmentString(numSlaves)).toInt(), new StringOps(Predef$.MODULE$.augmentString(coresPerSlave)).toInt(), memoryPerSlaveInt, sc.conf());
                            String[] masterUrls = localCluster.start();
                            StandaloneSchedulerBackend backend6 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                            scheduler.initialize(backend6);
                            backend6.shutdownCallback_$eq((Function1<StandaloneSchedulerBackend, BoxedUnit>)(Function1 & Serializable & scala.Serializable)backend -> {
                                localCluster.stop();
                                return BoxedUnit.UNIT;
                            });
                            tuple2 = new Tuple2((Object)backend6, (Object)scheduler);
                        } else {
                            Tuple2 tuple22;
                            ExternalClusterManager clusterMgr;
                            Option<ExternalClusterManager> option5 = this.getClusterManager(string);
                            if (!(option5 instanceof Some)) {
                                if (None$.MODULE$.equals(option5)) {
                                    throw new SparkException(new StringBuilder(30).append("Could not parse Master URL: '").append(master).append("'").toString());
                                }
                                throw new MatchError(option5);
                            }
                            Some some = (Some)option5;
                            ExternalClusterManager externalClusterManager = clusterMgr = (ExternalClusterManager)some.value();
                            ExternalClusterManager cm = externalClusterManager;
                            try {
                                TaskScheduler scheduler = cm.createTaskScheduler(sc, string);
                                SchedulerBackend backend7 = cm.createSchedulerBackend(sc, string, scheduler);
                                cm.initialize(scheduler, backend7);
                                tuple22 = new Tuple2((Object)backend7, (Object)scheduler);
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                if (throwable2 instanceof SparkException) {
                                    SparkException sparkException = (SparkException)throwable2;
                                    throw sparkException;
                                }
                                Option option6 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option6.isEmpty()) {
                                    Throwable e = (Throwable)option6.get();
                                    throw new SparkException("External scheduler cannot be instantiated", e);
                                }
                                throw throwable;
                            }
                            tuple2 = tuple22;
                        }
                    }
                }
            }
        }
        return tuple2;
    }

    private Option<ExternalClusterManager> getClusterManager(String url) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(ExternalClusterManager.class, loader)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)x$39.canCreate(url)));
        if (serviceLoaders.size() > 1) {
            throw new SparkException(new StringBuilder(60).append("Multiple external cluster managers registered for the url ").append(url).append(": ").append(serviceLoaders).toString());
        }
        return serviceLoaders.headOption();
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$1(SparkContext sc$1, SparkContext x$35) {
        return x$35 != sc$1;
    }

    public static final /* synthetic */ void $anonfun$assertNoOtherContextIsRunning$2(boolean allowMultipleContexts$1, SparkContext ctx) {
        String errMsg = new StringBuilder(136).append("Only one SparkContext may be running in this JVM (see SPARK-2243). To ignore this error, set spark.driver.allowMultipleContexts = true. ").append(new StringBuilder(51).append("The currently running SparkContext was created at:\n").append(ctx.org$apache$spark$SparkContext$$creationSite().longForm()).toString()).toString();
        SparkException exception = new SparkException(errMsg);
        if (!allowMultipleContexts$1) {
            throw exception;
        }
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Multiple running SparkContexts detected in the same JVM!", exception);
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$4(SparkContext sc$1, SparkContext x$36) {
        return x$36 != sc$1;
    }

    public static final /* synthetic */ void $anonfun$assertNoOtherContextIsRunning$5(SparkContext otherContext) {
        String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.longForm()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown location");
        String warnMsg = new StringBuilder(187).append("Another SparkContext is being constructed (or threw an exception in its constructor).  This may indicate an error, since only one SparkContext may be running in this JVM (see SPARK-2243).").append(new StringBuilder(40).append(" The other SparkContext was created at:\n").append(otherContextCreationSite).toString()).toString();
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warnMsg);
    }

    private static final Writable anyToWritable$1(Writable u) {
        return u;
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
    }

    private static final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private SparkContext$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALL", "DEBUG", "ERROR", "FATAL", "INFO", "OFF", "TRACE", "WARN"}));
        this.SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        this.org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        this.contextBeingConstructed = None$.MODULE$;
        this.SPARK_JOB_DESCRIPTION = "spark.job.description";
        this.SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        this.SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        this.RDD_SCOPE_KEY = "spark.rdd.scope";
        this.RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        this.DRIVER_IDENTIFIER = "driver";
        this.LEGACY_DRIVER_IDENTIFIER = "<driver>";
    }
}

