/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MapOutputTracker$
implements Logging {
    public static MapOutputTracker$ MODULE$;
    private final String ENDPOINT_NAME;
    private final int DIRECT;
    private final int BROADCAST;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MapOutputTracker$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ENDPOINT_NAME() {
        return this.ENDPOINT_NAME;
    }

    private int DIRECT() {
        return this.DIRECT;
    }

    private int BROADCAST() {
        return this.BROADCAST;
    }

    public Tuple2<byte[], Broadcast<byte[]>> serializeMapStatuses(MapStatus[] statuses, BroadcastManager broadcastManager, boolean isLocal, int minBroadcastSize) {
        Tuple2 tuple2;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.DIRECT());
        ObjectOutputStream objOut = new ObjectOutputStream(new GZIPOutputStream(out));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MapStatus[] mapStatusArray = statuses;
            synchronized (statuses) {
                objOut.writeObject(statuses);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> objOut.close());
        byte[] arr = out.toByteArray();
        if (arr.length >= minBroadcastSize) {
            Broadcast<byte[]> bcast = broadcastManager.newBroadcast(arr, isLocal, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            out.reset();
            out.write(this.BROADCAST());
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(out));
            oos.writeObject(bcast);
            oos.close();
            byte[] outArr = out.toByteArray();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broadcast mapstatuses size = ").append(outArr.length).append(", actual size = ").append(arr.length).toString());
            tuple2 = new Tuple2((Object)outArr, bcast);
        } else {
            tuple2 = new Tuple2((Object)arr, null);
        }
        return tuple2;
    }

    public MapStatus[] deserializeMapStatuses(byte[] bytes) {
        MapStatus[] mapStatusArray;
        Predef$.MODULE$.assert(bytes.length > 0);
        byte by = bytes[0];
        if (this.DIRECT() == by) {
            mapStatusArray = (MapStatus[])MapOutputTracker$.deserializeObject$1(bytes, 1, bytes.length - 1);
        } else if (this.BROADCAST() == by) {
            Broadcast bcast = (Broadcast)MapOutputTracker$.deserializeObject$1(bytes, 1, bytes.length - 1);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broadcast mapstatuses size = ").append(bytes.length).append(", actual size = ").append(((byte[])bcast.value()).length).toString());
            mapStatusArray = (MapStatus[])MapOutputTracker$.deserializeObject$1((byte[])bcast.value(), 1, ((byte[])bcast.value()).length - 1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected byte tag = ").append(bytes[0]).toString());
        }
        return mapStatusArray;
    }

    public Iterator<Tuple2<BlockManagerId, Seq<Tuple2<BlockId, Object>>>> convertMapStatuses(int shuffleId, int startPartition, int endPartition, MapStatus[] statuses) {
        Predef$.MODULE$.assert(statuses != null);
        HashMap splitsByAddress = new HashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).iterator().zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            MapOutputTracker$.$anonfun$convertMapStatuses$2(shuffleId, startPartition, endPartition, splitsByAddress, x$7);
            return BoxedUnit.UNIT;
        });
        return splitsByAddress.iterator();
    }

    private static final Object deserializeObject$1(byte[] arr, int off, int len) {
        ObjectInputStream objIn = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(arr, off, len)));
        return Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> objIn.readObject(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> objIn.close());
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$convertMapStatuses$4(int shuffleId$3, HashMap splitsByAddress$1, MapStatus status$1, int mapId$1, int part) {
        long size = status$1.getSizeForBlock(part);
        return size != 0L ? ((ListBuffer)splitsByAddress$1.getOrElseUpdate((Object)status$1.location(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple2((Object)new ShuffleBlockId(shuffleId$3, mapId$1, part), (Object)BoxesRunTime.boxToLong((long)size))) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertMapStatuses$2(int shuffleId$3, int startPartition$2, int endPartition$2, HashMap splitsByAddress$1, Tuple2 x$7) {
        int mapId;
        MapStatus status;
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            status = (MapStatus)tuple2._1();
            mapId = tuple2._2$mcI$sp();
            if (status == null) {
                String errorMessage = new StringBuilder(39).append("Missing an output location for shuffle ").append(shuffleId$3).toString();
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
                throw new MetadataFetchFailedException(shuffleId$3, startPartition$2, errorMessage);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPartition$2), endPartition$2).foreach((Function1 & Serializable & scala.Serializable)part -> MapOutputTracker$.$anonfun$convertMapStatuses$4(shuffleId$3, splitsByAddress$1, status, mapId, BoxesRunTime.unboxToInt((Object)part)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private MapOutputTracker$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ENDPOINT_NAME = "MapOutputTracker";
        this.DIRECT = 0;
        this.BROADCAST = 1;
    }
}

