/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescription
implements Serializable {
    private String applicationName;
    private String description;
    private Date dateCreated;
    private Date dateUpdated;
    private List<String> versions;
    private List<String> configurationTemplates;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ApplicationDescription withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApplicationDescription withDescription(String description) {
        this.description = description;
        return this;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ApplicationDescription withDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public ApplicationDescription withDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public List<String> getVersions() {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        return this.versions;
    }

    public void setVersions(Collection<String> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        ArrayList<String> versionsCopy = new ArrayList<String>(versions.size());
        versionsCopy.addAll(versions);
        this.versions = versionsCopy;
    }

    public ApplicationDescription withVersions(String ... versions) {
        if (this.getVersions() == null) {
            this.setVersions(new ArrayList<String>(versions.length));
        }
        for (String value : versions) {
            this.getVersions().add(value);
        }
        return this;
    }

    public ApplicationDescription withVersions(Collection<String> versions) {
        if (versions == null) {
            this.versions = null;
        } else {
            ArrayList<String> versionsCopy = new ArrayList<String>(versions.size());
            versionsCopy.addAll(versions);
            this.versions = versionsCopy;
        }
        return this;
    }

    public List<String> getConfigurationTemplates() {
        if (this.configurationTemplates == null) {
            this.configurationTemplates = new ArrayList<String>();
        }
        return this.configurationTemplates;
    }

    public void setConfigurationTemplates(Collection<String> configurationTemplates) {
        if (configurationTemplates == null) {
            this.configurationTemplates = null;
            return;
        }
        ArrayList<String> configurationTemplatesCopy = new ArrayList<String>(configurationTemplates.size());
        configurationTemplatesCopy.addAll(configurationTemplates);
        this.configurationTemplates = configurationTemplatesCopy;
    }

    public ApplicationDescription withConfigurationTemplates(String ... configurationTemplates) {
        if (this.getConfigurationTemplates() == null) {
            this.setConfigurationTemplates(new ArrayList<String>(configurationTemplates.length));
        }
        for (String value : configurationTemplates) {
            this.getConfigurationTemplates().add(value);
        }
        return this;
    }

    public ApplicationDescription withConfigurationTemplates(Collection<String> configurationTemplates) {
        if (configurationTemplates == null) {
            this.configurationTemplates = null;
        } else {
            ArrayList<String> configurationTemplatesCopy = new ArrayList<String>(configurationTemplates.size());
            configurationTemplatesCopy.addAll(configurationTemplates);
            this.configurationTemplates = configurationTemplatesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: " + this.getDateCreated() + ", ");
        }
        if (this.getDateUpdated() != null) {
            sb.append("DateUpdated: " + this.getDateUpdated() + ", ");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: " + this.getVersions() + ", ");
        }
        if (this.getConfigurationTemplates() != null) {
            sb.append("ConfigurationTemplates: " + this.getConfigurationTemplates() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDateUpdated() == null ? 0 : this.getDateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : ((Object)this.getVersions()).hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationTemplates() == null ? 0 : ((Object)this.getConfigurationTemplates()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription other = (ApplicationDescription)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        if (other.getDateCreated() != null && !other.getDateCreated().equals(this.getDateCreated())) {
            return false;
        }
        if (other.getDateUpdated() == null ^ this.getDateUpdated() == null) {
            return false;
        }
        if (other.getDateUpdated() != null && !other.getDateUpdated().equals(this.getDateUpdated())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !((Object)other.getVersions()).equals(this.getVersions())) {
            return false;
        }
        if (other.getConfigurationTemplates() == null ^ this.getConfigurationTemplates() == null) {
            return false;
        }
        return other.getConfigurationTemplates() == null || ((Object)other.getConfigurationTemplates()).equals(this.getConfigurationTemplates());
    }
}

