/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.joda.columnmapper;

import org.jadira.usertype.moneyandcurrency.joda.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class LongColumnMoneyMinorMapper
extends AbstractLongColumnMapper<Money>
implements CurrencyUnitConfigured {
    private static final long serialVersionUID = 4205713919952452881L;
    private CurrencyUnit currencyUnit;

    public Money fromNonNullValue(Long val) {
        return Money.ofMinor((CurrencyUnit)this.currencyUnit, (long)val);
    }

    public Long toNonNullValue(Money value) {
        if (!this.currencyUnit.equals((Object)value.getCurrencyUnit())) {
            throw new IllegalStateException("Expected currency " + this.currencyUnit.getCurrencyCode() + " but was " + value.getCurrencyUnit());
        }
        return value.getAmountMinorLong();
    }

    public Money fromNonNullString(String s) {
        return Money.parse((String)s);
    }

    public String toNonNullString(Money value) {
        return value.toString();
    }

    @Override
    public void setCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
    }
}

