/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;

public class TimestampColumnLocalTimeMapper
extends AbstractVersionableTimestampColumnMapper<LocalTime> {
    private static final long serialVersionUID = 1921591625617366103L;
    public static final DateTimeFormatter LOCAL_DATETIME_PRINTER = new DateTimeFormatterBuilder().appendPattern("0001-01-01 HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter LOCAL_DATETIME_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    public LocalTime fromNonNullString(String s) {
        return LocalTime.parse(s);
    }

    public LocalTime fromNonNullValue(Timestamp value) {
        return value.toLocalDateTime().toLocalTime();
    }

    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(LocalTime value) {
        LocalDateTime ldt = LocalDateTime.of(1970, Month.JANUARY, 1, value.getHour(), value.getMinute(), value.getSecond(), value.getNano());
        return Timestamp.valueOf(ldt);
    }
}

