/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared.descriptor.sql;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.DateTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DstSafeDateTypeDescriptor
extends DateTypeDescriptor {
    private static final long serialVersionUID = -1927559005967709998L;
    private final Calendar cal;
    public static final DstSafeDateTypeDescriptor INSTANCE = new DstSafeDateTypeDescriptor();

    public DstSafeDateTypeDescriptor() {
        this.cal = null;
    }

    public DstSafeDateTypeDescriptor(Calendar cal) {
        this.cal = cal;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (DstSafeDateTypeDescriptor.this.cal == null) {
                    st.setDate(index, (Date)javaTypeDescriptor.unwrap(value, Date.class, options));
                } else {
                    st.setDate(index, (Date)javaTypeDescriptor.unwrap(value, Date.class, options), DstSafeDateTypeDescriptor.this.cal);
                }
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                if (DstSafeDateTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap((Object)rs.getDate(name), options);
                }
                return javaTypeDescriptor.wrap((Object)rs.getDate(name, DstSafeDateTypeDescriptor.this.cal), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (DstSafeDateTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap((Object)statement.getDate(index), options);
                }
                return javaTypeDescriptor.wrap((Object)statement.getDate(index, DstSafeDateTypeDescriptor.this.cal), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (DstSafeDateTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap((Object)statement.getDate(name), options);
                }
                return javaTypeDescriptor.wrap((Object)statement.getDate(name, DstSafeDateTypeDescriptor.this.cal), options);
            }
        };
    }
}

